/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.ThrottleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleConfigurationImpl
implements ThrottleConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThrottleConfigurationImpl.class);
    public static final long DEFAULT_STREAM_REQUESTS_PER_SEC = 5000L;
    public static final SecondBoundConfiguration DEFAULT_TIMEOUT = SecondBoundConfiguration.parse((String)"10s");
    public static final String STREAM_REQUESTS_PER_SEC_PROPERTY = "stream_requests_per_sec";
    public static final String TIMEOUT_PROPERTY = "timeout";
    @JsonProperty(value="stream_requests_per_sec")
    protected final long rateLimitStreamRequestsPerSecond;
    protected SecondBoundConfiguration timeout;

    public ThrottleConfigurationImpl() {
        this(5000L, DEFAULT_TIMEOUT);
    }

    public ThrottleConfigurationImpl(long rateLimitStreamRequestsPerSecond) {
        this(rateLimitStreamRequestsPerSecond, DEFAULT_TIMEOUT);
    }

    public ThrottleConfigurationImpl(long rateLimitStreamRequestsPerSecond, SecondBoundConfiguration timeout) {
        this.rateLimitStreamRequestsPerSecond = rateLimitStreamRequestsPerSecond;
        this.timeout = timeout;
    }

    @Override
    @JsonProperty(value="stream_requests_per_sec")
    public long rateLimitStreamRequestsPerSecond() {
        return this.rateLimitStreamRequestsPerSecond;
    }

    @Override
    @JsonProperty(value="timeout")
    public SecondBoundConfiguration timeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    public void setTimeout(SecondBoundConfiguration timeout) {
        this.timeout = timeout;
    }

    @JsonProperty(value="timeout_sec")
    @Deprecated
    public void setTimeoutInSeconds(long timeoutInSeconds) {
        LOGGER.warn("'timeout_sec' is deprecated, use '{}' instead", (Object)TIMEOUT_PROPERTY);
        this.setTimeout(new SecondBoundConfiguration(timeoutInSeconds, TimeUnit.SECONDS));
    }
}

