/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.google.inject.Inject;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.OrAuthorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.server.MetricsOperations;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;

public class TableStatsHandler
extends AbstractHandler<QualifiedTableName>
implements AccessProtected {
    @Inject
    protected TableStatsHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator) {
        super(metadataFetcher, executorPools, validator);
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        OrAuthorization authorization = OrAuthorization.create();
        authorization.addAuthorization(BasicPermissions.STATS_TABLE_SCOPED.toAuthorization());
        authorization.addAuthorization(BasicPermissions.STATS_CLUSTER_SCOPED.toAuthorization());
        return Collections.singleton(authorization);
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, String host, SocketAddress remoteAddress, QualifiedTableName tableName) {
        MetricsOperations operations = this.metadataFetcher.delegate(host).metricsOperations();
        this.executorPools.service().executeBlocking(() -> operations.tableStats(tableName)).onSuccess(arg_0 -> ((RoutingContext)context).json(arg_0)).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, tableName));
    }

    @Override
    protected QualifiedTableName extractParamsOrThrow(RoutingContext context) {
        return this.qualifiedTableName(context);
    }
}

