/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mtls.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.CertificateCredentials;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.mtls.CertificateIdentityExtractor;
import io.vertx.ext.auth.mtls.CertificateValidator;
import io.vertx.ext.auth.mtls.MutualTlsAuthentication;
import io.vertx.ext.auth.mtls.impl.MutualTlsUser;
import java.util.List;

public class MutualTlsAuthenticationImpl
implements MutualTlsAuthentication {
    private final Vertx vertx;
    private final CertificateValidator certificateValidator;
    private final CertificateIdentityExtractor identityExtractor;

    public MutualTlsAuthenticationImpl(Vertx vertx, CertificateValidator certificateValidator, CertificateIdentityExtractor identityExtractor) {
        this.vertx = vertx;
        this.certificateValidator = certificateValidator;
        this.identityExtractor = identityExtractor;
    }

    public Future<User> authenticate(Credentials credentials) {
        if (!(credentials instanceof CertificateCredentials)) {
            return Future.failedFuture((String)"CertificateCredentials expected for mTLS authentication");
        }
        CertificateCredentials certificateCredentials = (CertificateCredentials)credentials;
        return this.vertx.executeBlocking(() -> {
            certificateCredentials.checkValid();
            this.certificateValidator.verifyCertificate(certificateCredentials);
            List<String> identities = this.identityExtractor.validIdentities(certificateCredentials);
            return MutualTlsUser.fromIdentities(identities);
        });
    }

    @Deprecated
    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
        throw new UnsupportedOperationException("Deprecated authentication method");
    }
}

