/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.cayenne.CayenneRuntimeException;

public class MemoryBlob
implements Blob {
    volatile byte[] data;

    public MemoryBlob() {
        this(new byte[0]);
    }

    public MemoryBlob(byte[] data) {
        if (data == null) {
            throw new CayenneRuntimeException("Null data", new Object[0]);
        }
        this.data = data;
    }

    @Override
    public long length() throws SQLException {
        return this.data.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] ldata = this.data;
        int dlen = ldata.length;
        if (--pos < 0L || pos > (long)dlen) {
            throw new SQLException("Invalid pos: " + (pos + 1L));
        }
        if (length < 0 || (long)length > (long)dlen - pos) {
            throw new SQLException("length: " + length);
        }
        byte[] out = new byte[length];
        System.arraycopy(ldata, (int)pos, out, 0, length);
        return out;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        byte[] ldata = this.data;
        int dlen = ldata.length;
        if (start > (long)dlen || pattern == null) {
            return -1L;
        }
        start = start < 1L ? 0L : --start;
        int plen = pattern.length;
        if (plen == 0 || start > (long)(dlen - plen)) {
            return -1L;
        }
        int stop = dlen - plen;
        byte b0 = pattern[0];
        block0: for (int i = (int)start; i <= stop; ++i) {
            if (ldata[i] != b0) continue;
            int len = plen;
            int doffset = i;
            int poffset = 0;
            while (len-- > 0) {
                if (ldata[doffset++] == pattern[poffset++]) continue;
                continue block0;
            }
            return i + 1;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        byte[] ldata = this.data;
        int dlen = ldata.length;
        if (start > (long)dlen || pattern == null) {
            return -1L;
        }
        start = start < 1L ? 0L : --start;
        long plen = pattern.length();
        if (plen == 0L || start > (long)dlen - plen) {
            return -1L;
        }
        int iplen = (int)plen;
        byte[] bap = pattern instanceof MemoryBlob ? ((MemoryBlob)pattern).data : pattern.getBytes(1L, iplen);
        int stop = dlen - iplen;
        byte b0 = bap[0];
        block0: for (int i = (int)start; i <= stop; ++i) {
            if (ldata[i] != b0) continue;
            int len = iplen;
            int doffset = i;
            int poffset = 0;
            while (len-- > 0) {
                if (ldata[doffset++] == bap[poffset++]) continue;
                continue block0;
            }
            return i + 1;
        }
        return -1L;
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public void truncate(long len) throws SQLException {
        byte[] ldata = this.data;
        if (len < 0L || len > (long)ldata.length) {
            throw new SQLException("Invalid length: " + Long.toString(len));
        }
        if (len == (long)ldata.length) {
            return;
        }
        byte[] newData = new byte[(int)len];
        System.arraycopy(ldata, 0, newData, 0, (int)len);
        this.data = newData;
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(long arg0, long arg1) throws SQLException {
        return null;
    }
}

