/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.dbsync.filter.NamePatternMatcher;
import org.apache.cayenne.dbsync.merge.context.EntityMergeSupport;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateObjEntityUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.util.DeleteRuleUpdater;

public class CreateObjEntityAction
extends CayenneAction {
    public CreateObjEntityAction(Application application) {
        super(CreateObjEntityAction.getActionName(), application);
    }

    public static String getActionName() {
        return "Create ObjEntity";
    }

    static void fireObjEntityEvent(Object src, ProjectController mediator, DataMap dataMap, ObjEntity entity) {
        mediator.fireObjEntityEvent(new EntityEvent(src, (Entity)entity, 2));
        EntityDisplayEvent displayEvent = new EntityDisplayEvent(src, entity, dataMap, mediator.getCurrentDataNode(), (DataChannelDescriptor)mediator.getProject().getRootNode());
        displayEvent.setMainTabFocus(true);
        mediator.fireObjEntityDisplayEvent(displayEvent);
    }

    @Override
    public String getIconName() {
        return "icon-objentity.png";
    }

    @Override
    public void performAction(ActionEvent e) {
        this.createObjEntity();
    }

    protected void createObjEntity() {
        ProjectController mediator = this.getProjectController();
        DataMap dataMap = mediator.getCurrentDataMap();
        ObjEntity entity = new ObjEntity();
        entity.setName(NameBuilder.builder(entity, dataMap).name());
        entity.setSuperClassName(dataMap.getDefaultSuperclass());
        entity.setDeclaredLockType(dataMap.getDefaultLockType());
        DbEntity dbEntity = mediator.getCurrentDbEntity();
        if (dbEntity != null) {
            entity.setDbEntity(dbEntity);
            String baseName = new DefaultObjectNameGenerator(NoStemStemmer.getInstance()).objEntityName(dbEntity);
            entity.setName(NameBuilder.builder(entity, dbEntity.getDataMap()).baseName(baseName).name());
        }
        entity.setClassName(dataMap.getNameWithDefaultPackage(entity.getName()));
        if (dataMap.isClientSupported()) {
            entity.setClientClassName(dataMap.getNameWithDefaultClientPackage(entity.getName()));
            entity.setClientSuperClassName(dataMap.getDefaultClientSuperclass());
        }
        dataMap.addObjEntity(entity);
        EntityMergeSupport merger = new EntityMergeSupport(new DefaultObjectNameGenerator(NoStemStemmer.getInstance()), NamePatternMatcher.EXCLUDE_ALL, true, true, false);
        merger.setNameGenerator(new DbEntitySyncAction.PreserveRelationshipNameGenerator());
        merger.addEntityMergeListener(DeleteRuleUpdater.getEntityMergeListener());
        merger.synchronizeWithDbEntity(entity);
        CreateObjEntityAction.fireObjEntityEvent(this, mediator, dataMap, entity);
        this.application.getUndoManager().addEdit(new CreateObjEntityUndoableEdit(dataMap, entity));
    }

    public void createObjEntity(DataMap dataMap, ObjEntity entity) {
        ProjectController mediator = this.getProjectController();
        dataMap.addObjEntity(entity);
        CreateObjEntityAction.fireObjEntityEvent(this, mediator, dataMap, entity);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ObjEntity) {
            return ((ObjEntity)object).getParent() != null && ((ObjEntity)object).getParent() instanceof DataMap;
        }
        return false;
    }
}

