/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.Serializable;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.graph.ArcId;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;

public class ObjectContextGraphAction
implements Serializable {
    protected ObjectContext context;

    public ObjectContextGraphAction(ObjectContext context) {
        this.context = context;
    }

    public void handlePropertyChange(Persistent object, String propertyName, Object oldValue, Object newValue) {
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(object.getObjectId().getEntityName());
        PropertyDescriptor property = descriptor.getProperty(propertyName);
        if (property instanceof ArcProperty) {
            this.handleArcPropertyChange(object, (ArcProperty)property, oldValue, newValue);
        } else {
            this.handleSimplePropertyChange(object, propertyName, oldValue, newValue);
        }
    }

    protected void handleArcPropertyChange(Persistent object, ArcProperty property, Object oldValue, Object newValue) {
        if (oldValue != newValue) {
            this.markAsDirty(object);
            if (oldValue instanceof Persistent) {
                this.context.getGraphManager().arcDeleted(object.getObjectId(), ((Persistent)oldValue).getObjectId(), new ArcId(property));
            }
            if (newValue instanceof Persistent) {
                this.context.getGraphManager().arcCreated(object.getObjectId(), ((Persistent)newValue).getObjectId(), new ArcId(property));
            }
        }
    }

    protected void handleSimplePropertyChange(Persistent object, String propertyName, Object oldValue, Object newValue) {
        this.context.getGraphManager().nodePropertyChanged(object.getObjectId(), propertyName, oldValue, newValue);
        this.markAsDirty(object);
    }

    protected boolean markAsDirty(Persistent object) {
        if (object.getPersistenceState() == 3) {
            object.setPersistenceState(4);
            return true;
        }
        return false;
    }
}

