/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.io.IOException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;

public class DefaultQuotingStrategy
implements QuotingStrategy {
    private final String endQuote;
    private final String startQuote;

    public DefaultQuotingStrategy(String startQuote, String endQuote) {
        this.startQuote = startQuote;
        this.endQuote = endQuote;
    }

    @Override
    public String quotedFullyQualifiedName(DbEntity entity) {
        return this.quotedIdentifier(entity.getDataMap(), entity.getCatalog(), entity.getSchema(), entity.getName());
    }

    @Override
    public String quotedName(DbAttribute attribute) {
        return this.quotedIdentifier(attribute.getEntity().getDataMap(), attribute.getName());
    }

    @Override
    public String quotedSourceName(DbJoin join) {
        DataMap dataMap = join.getSource().getEntity().getDataMap();
        return this.quotedIdentifier(dataMap, join.getSourceName());
    }

    @Override
    public String quotedTargetName(DbJoin join) {
        DataMap dataMap = join.getTarget().getEntity().getDataMap();
        return this.quotedIdentifier(dataMap, join.getTargetName());
    }

    @Override
    public void quotedIdentifier(DataMap dataMap, CharSequence identifier, Appendable appender) {
        if (identifier == null) {
            return;
        }
        boolean quoting = dataMap != null && dataMap.isQuotingSQLIdentifiers();
        try {
            if (quoting) {
                appender.append(this.startQuote).append(identifier).append(this.endQuote);
            } else {
                appender.append(identifier);
            }
        }
        catch (IOException ex) {
            throw new CayenneRuntimeException("Failed to append quoted identifier", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    public String quotedIdentifier(DataMap dataMap, String ... identifierParts) {
        boolean quoting = dataMap != null && dataMap.isQuotingSQLIdentifiers();
        StringBuilder buffer = new StringBuilder();
        for (String part : identifierParts) {
            if (part == null) continue;
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            if (quoting) {
                buffer.append(this.startQuote).append(part).append(this.endQuote);
                continue;
            }
            buffer.append(part);
        }
        return buffer.toString();
    }
}

