/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.io.CombinedLocationStrategy;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCombinedLocationStrategy {
    private static FileLocator locator;
    private static URL locateURL;
    private FileSystem fileSystem;
    private FileLocationStrategy[] subStrategies;

    @BeforeAll
    public static void setUpOnce() throws Exception {
        locator = FileLocatorUtils.fileLocator().fileName("testFile.tst").create();
        locateURL = ConfigurationAssert.getTestURL("test.xml");
    }

    private void checkSubStrategies(CombinedLocationStrategy strategy) {
        Collection subs = strategy.getSubStrategies();
        Assertions.assertIterableEquals(Arrays.asList(this.getSubStrategies()), (Iterable)subs);
    }

    private CombinedLocationStrategy createCombinedStrategy() {
        return new CombinedLocationStrategy(Arrays.asList(this.getSubStrategies()));
    }

    private FileSystem getFileSystem() {
        if (this.fileSystem == null) {
            this.fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        }
        return this.fileSystem;
    }

    private FileLocationStrategy[] getSubStrategies() {
        if (this.subStrategies == null) {
            this.subStrategies = new FileLocationStrategy[2];
            for (int i = 0; i < this.subStrategies.length; ++i) {
                this.subStrategies[i] = (FileLocationStrategy)Mockito.mock(FileLocationStrategy.class);
            }
        }
        return this.subStrategies;
    }

    @Test
    void testGetSubStrategiesModify() {
        CombinedLocationStrategy strategy = this.createCombinedStrategy();
        Collection strategies = strategy.getSubStrategies();
        Assertions.assertThrows(UnsupportedOperationException.class, strategies::clear);
    }

    @Test
    void testInitCollectionWithNullEntries() {
        LinkedList<FileLocationStrategy> col = new LinkedList<FileLocationStrategy>(Arrays.asList(this.getSubStrategies()));
        col.add(null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CombinedLocationStrategy(col));
    }

    @Test
    void testInitDefensiveCopy() {
        LinkedList<FileLocationStrategy> col = new LinkedList<FileLocationStrategy>(Arrays.asList(this.getSubStrategies()));
        CombinedLocationStrategy strategy = new CombinedLocationStrategy(col);
        col.add((FileLocationStrategy)Mockito.mock(FileLocationStrategy.class));
        this.checkSubStrategies(strategy);
    }

    @Test
    void testInitNullCollection() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CombinedLocationStrategy(null));
    }

    @Test
    void testLocateFailed() {
        Mockito.when((Object)this.getSubStrategies()[0].locate(this.getFileSystem(), locator)).thenReturn(null);
        Mockito.when((Object)this.getSubStrategies()[1].locate(this.getFileSystem(), locator)).thenReturn(null);
        CombinedLocationStrategy strategy = this.createCombinedStrategy();
        Assertions.assertNull((Object)strategy.locate(this.getFileSystem(), locator));
        ((FileLocationStrategy)Mockito.verify((Object)this.getSubStrategies()[0])).locate(this.getFileSystem(), locator);
        ((FileLocationStrategy)Mockito.verify((Object)this.getSubStrategies()[1])).locate(this.getFileSystem(), locator);
        this.verifyNoMoreSubCategoryInteractions();
    }

    @Test
    void testLocateSuccessFirstSubStrategy() {
        Mockito.when((Object)this.getSubStrategies()[0].locate(this.getFileSystem(), locator)).thenReturn((Object)locateURL);
        CombinedLocationStrategy strategy = this.createCombinedStrategy();
        Assertions.assertSame((Object)locateURL, (Object)strategy.locate(this.getFileSystem(), locator));
        ((FileLocationStrategy)Mockito.verify((Object)this.getSubStrategies()[0])).locate(this.getFileSystem(), locator);
        this.verifyNoMoreSubCategoryInteractions();
    }

    @Test
    void testLocateSuccessSecondSubStrategy() {
        Mockito.when((Object)this.getSubStrategies()[0].locate(this.getFileSystem(), locator)).thenReturn(null);
        Mockito.when((Object)this.getSubStrategies()[1].locate(this.getFileSystem(), locator)).thenReturn((Object)locateURL);
        CombinedLocationStrategy strategy = this.createCombinedStrategy();
        Assertions.assertSame((Object)locateURL, (Object)strategy.locate(this.getFileSystem(), locator));
        ((FileLocationStrategy)Mockito.verify((Object)this.getSubStrategies()[0])).locate(this.getFileSystem(), locator);
        ((FileLocationStrategy)Mockito.verify((Object)this.getSubStrategies()[1])).locate(this.getFileSystem(), locator);
        this.verifyNoMoreSubCategoryInteractions();
    }

    private void verifyNoMoreSubCategoryInteractions() {
        Mockito.verifyNoMoreInteractions((Object[])this.getSubStrategies());
    }
}

