/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.io.build.AbstractOrigin;
import org.apache.commons.io.build.AbstractOriginTest;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;

class ChannelOriginTest
extends AbstractOriginTest<Channel, AbstractOrigin.ChannelOrigin> {
    ChannelOriginTest() {
    }

    @Override
    protected AbstractOrigin.ChannelOrigin newOriginRo() throws IOException {
        return new AbstractOrigin.ChannelOrigin((Channel)Files.newByteChannel(Paths.get("src/test/resources/org/apache/commons/io/test-file-20byteslength.bin", new String[0]), Collections.singleton(StandardOpenOption.READ), new FileAttribute[0]));
    }

    @Override
    protected AbstractOrigin.ChannelOrigin newOriginRw() throws IOException {
        return new AbstractOrigin.ChannelOrigin((Channel)Files.newByteChannel(this.tempPath.resolve(FILE_NAME_RW), new HashSet<StandardOpenOption>(Arrays.asList(StandardOpenOption.READ, StandardOpenOption.WRITE)), new FileAttribute[0]));
    }

    @Override
    protected void resetOriginRw() throws IOException {
        Path rwPath = this.tempPath.resolve(FILE_NAME_RW);
        Files.write(rwPath, ArrayUtils.EMPTY_BYTE_ARRAY, StandardOpenOption.CREATE);
    }

    @Override
    @Test
    void testGetFile() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testGetFile());
    }

    @Override
    @Test
    void testGetPath() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testGetPath());
    }

    @Override
    @Test
    void testGetRandomAccessFile() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testGetRandomAccessFile());
    }

    @Override
    @ParameterizedTest
    @EnumSource(value=StandardOpenOption.class)
    void testGetRandomAccessFile(OpenOption openOption) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testGetRandomAccessFile(openOption));
    }

    @Test
    void testUnsupportedOperations_ReadableByteChannel() {
        ReadableByteChannel channel = (ReadableByteChannel)Mockito.mock(ReadableByteChannel.class);
        AbstractOrigin.ChannelOrigin origin = new AbstractOrigin.ChannelOrigin((Channel)channel);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> origin.getOutputStream(new OpenOption[0]));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> origin.getWriter(null, new OpenOption[0]));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> origin.getChannel(WritableByteChannel.class, new OpenOption[0]));
    }

    @Test
    void testUnsupportedOperations_WritableByteChannel() {
        Channel channel = (Channel)Mockito.mock(WritableByteChannel.class);
        AbstractOrigin.ChannelOrigin origin = new AbstractOrigin.ChannelOrigin(channel);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> origin.getInputStream(new OpenOption[0]));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> origin.getReader(null));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> origin.getChannel(ReadableByteChannel.class, new OpenOption[0]));
    }
}

