/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration.builders;

import java.util.regex.Pattern;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.matchers.SimpleRegexMatcher;
import org.apache.rat.config.parameters.MatcherBuilder;
import org.apache.rat.configuration.builders.AbstractBuilder;

@MatcherBuilder(value=SimpleRegexMatcher.class)
public class RegexBuilder
extends AbstractBuilder {
    private Pattern pattern;

    public RegexBuilder setExpression(String expression) {
        this.pattern = expression == null ? null : Pattern.compile(expression);
        return this;
    }

    @Override
    public SimpleRegexMatcher build() {
        if (null == this.pattern) {
            throw new ConfigurationException("'regex' type matcher requires an expression");
        }
        return new SimpleRegexMatcher(this.getId(), this.pattern);
    }

    @Override
    public String toString() {
        return String.format("RegexBuilder: %s", this.pattern == null ? null : this.pattern.pattern());
    }
}

