/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document;

import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;

public class TraceableDocumentNameMatcher
implements DocumentNameMatcher {
    public static final String ENV_VAR = TraceableDocumentNameMatcher.class.getName();
    private final DocumentNameMatcher delegate;
    private static final boolean TRACE_ENABLED = Boolean.parseBoolean(System.getenv(ENV_VAR));
    protected final Supplier<String> name;
    public static final TraceableDocumentNameMatcher TRUE = TraceableDocumentNameMatcher.make(() -> "True", pth -> true);
    public static final TraceableDocumentNameMatcher FALSE = TraceableDocumentNameMatcher.make(() -> "False", pth -> false);

    public static TraceableDocumentNameMatcher make(Supplier<String> name, DocumentNameMatcher delegate) {
        if (delegate instanceof TraceableDocumentNameMatcher) {
            return (TraceableDocumentNameMatcher)delegate;
        }
        return new TraceableDocumentNameMatcher(name, delegate);
    }

    public static TraceableDocumentNameMatcher from(FileFilter fileFilter) {
        return new TraceableDocumentNameMatcher(fileFilter::toString, DocumentNameMatcher.from(fileFilter));
    }

    protected TraceableDocumentNameMatcher(Supplier<String> name, DocumentNameMatcher delegate) {
        this.name = name;
        this.delegate = delegate;
    }

    public static TraceableDocumentNameMatcher not(final TraceableDocumentNameMatcher nameMatcher) {
        if (nameMatcher == TRUE) {
            return FALSE;
        }
        if (nameMatcher == FALSE) {
            return TRUE;
        }
        return new TraceableDocumentNameMatcher(() -> "not", documentName -> !nameMatcher.matches(documentName)){

            @Override
            public String toString() {
                return String.format("not(%s)", nameMatcher);
            }
        };
    }

    public static TraceableDocumentNameMatcher or(final Collection<TraceableDocumentNameMatcher> matchers) {
        if (matchers.isEmpty()) {
            return FALSE;
        }
        if (matchers.size() == 1) {
            return matchers.iterator().next();
        }
        if (matchers.contains(TRUE)) {
            return TRUE;
        }
        return new TraceableDocumentNameMatcher(() -> "or", documentName -> {
            for (DocumentNameMatcher matcher : matchers) {
                if (!matcher.matches(documentName)) continue;
                return true;
            }
            return false;
        }){

            @Override
            public String toString() {
                ArrayList children = new ArrayList();
                matchers.forEach(s -> children.add(s.toString()));
                return String.format("%s(%s)", this.name.get(), String.join((CharSequence)", ", children));
            }
        };
    }

    public static TraceableDocumentNameMatcher or(TraceableDocumentNameMatcher ... matchers) {
        return TraceableDocumentNameMatcher.or(Arrays.asList(matchers));
    }

    public static TraceableDocumentNameMatcher and(final TraceableDocumentNameMatcher ... matchers) {
        if (matchers.length == 0) {
            return FALSE;
        }
        if (matchers.length == 1) {
            return matchers[0];
        }
        if (Arrays.asList(matchers).contains(FALSE)) {
            return FALSE;
        }
        return new TraceableDocumentNameMatcher(() -> "and", documentName -> {
            for (TraceableDocumentNameMatcher matcher : matchers) {
                if (matcher.matches(documentName)) continue;
                return false;
            }
            return true;
        }){

            @Override
            public String toString() {
                ArrayList children = new ArrayList();
                Arrays.asList(matchers).forEach(s -> children.add(s.toString()));
                return String.format("%s(%s)", this.name.get(), String.join((CharSequence)", ", children));
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name.get());
        if (this.delegate instanceof TraceableDocumentNameMatcher) {
            sb.append(" ").append(this.delegate);
        }
        return sb.toString();
    }

    @Override
    public boolean matches(DocumentName documentName) {
        boolean result = this.delegate.matches(documentName);
        if (TRACE_ENABLED && DefaultLog.getInstance().isEnabled(Log.Level.DEBUG)) {
            DefaultLog.getInstance().debug(String.format("{%s} %s %s", documentName, result, this));
        }
        return result;
    }
}

