/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.JavaUtils;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.model.DefaultValueWriter;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.NameUtil;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.WrapperElement;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ProcessorUtil {
    private static final String KEYWORDS_PREFIX = "_";

    private ProcessorUtil() {
    }

    public static String resolvePartName(MessagePartInfo part) {
        return NameUtil.mangleNameToVariableName((String)part.getName().getLocalPart());
    }

    public static String getPartType(MessagePartInfo part) {
        return part.getConcreteName().getLocalPart();
    }

    public static String resolvePartType(MessagePartInfo part) {
        return NameUtil.mangleNameToClassName((String)ProcessorUtil.getPartType(part));
    }

    public static String getType(MessagePartInfo part, ToolContext context, boolean fullname) {
        DataBindingProfile dataBinding = (DataBindingProfile)context.get(DataBindingProfile.class);
        String type = part.isElement() ? dataBinding.getType(ProcessorUtil.getElementName(part), true) : dataBinding.getType(part.getTypeQName(), false);
        if (type == null) {
            type = ProcessorUtil.resolvePartType(part);
        }
        return type;
    }

    public static DefaultValueWriter getDefaultValueWriter(MessagePartInfo part, ToolContext context) {
        DataBindingProfile dataBinding = (DataBindingProfile)context.get(DataBindingProfile.class);
        if (part.isElement()) {
            return dataBinding.createDefaultValueWriter(ProcessorUtil.getElementName(part), true);
        }
        return dataBinding.createDefaultValueWriter(part.getTypeQName(), false);
    }

    public static DefaultValueWriter getDefaultValueWriterForWrappedElement(MessagePartInfo part, ToolContext context, QName subElement) {
        DataBindingProfile dataBinding = (DataBindingProfile)context.get(DataBindingProfile.class);
        return dataBinding.createDefaultValueWriterForWrappedElement(part.getElementQName(), subElement);
    }

    public static QName getElementName(MessagePartInfo part) {
        return part == null ? null : part.getConcreteName();
    }

    public static QName getMappedElementName(MessagePartInfo part, ToolContext env) {
        QName origin = ProcessorUtil.getElementName(part);
        if (origin == null) {
            return null;
        }
        if (!env.hasNamespace(origin.getNamespaceURI())) {
            return origin;
        }
        return new QName(env.getCustomizedNS(origin.getNamespaceURI()), origin.getLocalPart());
    }

    public static String resolvePartType(MessagePartInfo part, ToolContext env) {
        if (env != null) {
            return ProcessorUtil.resolvePartType(part, env, false);
        }
        return ProcessorUtil.resolvePartType(part);
    }

    public static String resolvePartType(MessagePartInfo part, ToolContext context, boolean fullName) {
        String pn;
        String namespace;
        DataBindingProfile dataBinding = (DataBindingProfile)context.get(DataBindingProfile.class);
        if (dataBinding == null) {
            String primitiveType = JAXBUtils.builtInTypeToJavaType((String)part.getTypeQName().getLocalPart());
            if (part.getTypeQName() != null && primitiveType != null) {
                return primitiveType;
            }
            return ProcessorUtil.resolvePartType(part);
        }
        String name = part.isElement() ? dataBinding.getType(ProcessorUtil.getElementName(part), true) : dataBinding.getType(part.getTypeQName(), false);
        if (name == null && "http://www.w3.org/2005/08/addressing".equals(namespace = ProcessorUtil.resolvePartNamespace(part)) && ("EndpointReference".equals(pn = part.getConcreteName().getLocalPart()) || "ReplyTo".equals(pn) || "From".equals(pn) || "FaultTo".equals(pn))) {
            name = "javax.xml.ws.wsaddressing.W3CEndpointReference";
        }
        return name;
    }

    public static String resolvePartNamespace(MessagePartInfo part) {
        return part.getConcreteName().getNamespaceURI();
    }

    public static String mangleNameToVariableName(String vName) {
        String result = NameUtil.mangleNameToVariableName((String)vName);
        if (JavaUtils.isJavaKeyword((String)result)) {
            return KEYWORDS_PREFIX + result;
        }
        return result;
    }

    public static String parsePackageName(String namespace, String defaultPackageName) {
        return PackageUtils.parsePackageName((String)namespace, (String)defaultPackageName);
    }

    public static String getAbsolutePath(String location) throws IOException {
        if (location.startsWith("http://")) {
            return location;
        }
        return new File(location).getAbsolutePath().replace('\\', '/');
    }

    public static URL getWSDLURL(String location) throws Exception {
        if (location.startsWith("http://")) {
            return new URL(location);
        }
        return new File(ProcessorUtil.getAbsolutePath(location)).toURI().toURL();
    }

    public static String classNameToFilePath(String className) {
        if (className.indexOf(46) < 0) {
            return className;
        }
        String str = className.replaceAll("\\.", "/");
        return str;
    }

    public static String getFullClzName(MessagePartInfo part, ToolContext context, boolean primitiveType) {
        DataBindingProfile dataBinding = (DataBindingProfile)context.get(DataBindingProfile.class);
        Object jtype = null;
        QName xmlTypeName = ProcessorUtil.getElementName(part);
        if (!primitiveType && dataBinding != null) {
            jtype = dataBinding.getType(xmlTypeName, true);
        }
        if (!primitiveType && dataBinding == null) {
            Class holderClass = JAXBUtils.holderClass((String)xmlTypeName.getLocalPart());
            Object object = jtype = holderClass == null ? null : holderClass.getName();
            if (jtype == null) {
                jtype = JAXBUtils.builtInTypeToJavaType((String)xmlTypeName.getLocalPart());
            }
        }
        if (primitiveType) {
            jtype = JAXBUtils.builtInTypeToJavaType((String)xmlTypeName.getLocalPart());
        }
        String namespace = xmlTypeName.getNamespaceURI();
        String type = ProcessorUtil.resolvePartType(part, context, true);
        String userPackage = context.mapPackageName(namespace);
        ClassCollector collector = (ClassCollector)context.get(ClassCollector.class);
        if (jtype == null) {
            jtype = collector.getTypesFullClassName(ProcessorUtil.parsePackageName(namespace, userPackage), type);
        }
        if (jtype == null) {
            jtype = !ProcessorUtil.resolvePartType(part).equals(type) ? ProcessorUtil.resolvePartType(part, context, true) : ProcessorUtil.parsePackageName(namespace, userPackage) + "." + type;
        }
        return jtype;
    }

    public static String getFileOrURLName(String fileOrURL) {
        try {
            try {
                return ProcessorUtil.escapeSpace(new URL(fileOrURL).toExternalForm());
            }
            catch (MalformedURLException e) {
                return new File(fileOrURL).getCanonicalFile().toURI().toURL().toExternalForm();
            }
        }
        catch (Exception e) {
            return fileOrURL;
        }
    }

    static String escapeSpace(String url) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < url.length(); ++i) {
            if (url.charAt(i) == ' ') {
                buf.append("%20");
                continue;
            }
            buf.append(url.charAt(i));
        }
        return buf.toString();
    }

    public static String absolutize(String name) {
        try {
            URL baseURL = new File(".").getCanonicalFile().toURI().toURL();
            return new URL(baseURL, name.replaceAll(" ", "%20")).toExternalForm();
        }
        catch (IOException iOException) {
            return name;
        }
    }

    public static String getHandlerConfigFileName(String name) {
        return name + "_handler";
    }

    public static Node cloneNode(Document document, Node node, boolean deep) throws DOMException {
        Node clone;
        if (document == null || node == null) {
            return null;
        }
        short type = node.getNodeType();
        if (node.getOwnerDocument() == document) {
            return node.cloneNode(deep);
        }
        switch (type) {
            case 4: {
                clone = document.createCDATASection(node.getNodeValue());
                break;
            }
            case 8: {
                clone = document.createComment(node.getNodeValue());
                break;
            }
            case 5: {
                clone = document.createEntityReference(node.getNodeName());
                break;
            }
            case 1: {
                clone = document.createElementNS(node.getNamespaceURI(), node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    Attr attrnew = ((Element)clone).getOwnerDocument().createAttributeNS(attr.getNamespaceURI(), attr.getNodeName());
                    attrnew.setValue(attr.getNodeValue());
                    ((Element)clone).setAttributeNodeNS(attrnew);
                }
                break;
            }
            case 3: {
                clone = document.createTextNode(node.getNodeValue());
                break;
            }
            default: {
                return null;
            }
        }
        if (deep && type == 1) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                clone.appendChild(ProcessorUtil.cloneNode(document, child, true));
            }
        }
        return clone;
    }

    public static List<QName> getWrappedElementQNames(ToolContext context, QName partElement) {
        ArrayList<QName> qnames = new ArrayList<QName>();
        if (partElement == null) {
            return qnames;
        }
        for (WrapperElement element : ProcessorUtil.getWrappedElement(context, partElement)) {
            qnames.add(element.getElementName());
        }
        return qnames;
    }

    public static List<WrapperElement> getWrappedElement(ToolContext context, QName partElement) {
        ServiceInfo serviceInfo = (ServiceInfo)context.get(ServiceInfo.class);
        SchemaCollection schema = serviceInfo.getXmlSchemaCollection();
        XmlSchemaElement elementByName = schema.getElementByQName(partElement);
        XmlSchemaComplexType type = (XmlSchemaComplexType)elementByName.getSchemaType();
        XmlSchemaSequence seq = (XmlSchemaSequence)type.getParticle();
        List<WrapperElement> qnames = ProcessorUtil.createWrappedElements(seq);
        if (seq == null && type.getContentModel() != null) {
            Object configuredMaxStackDepth = context.get("maxExtensionStackDepth");
            Integer maxStackDepth = 5;
            if (configuredMaxStackDepth instanceof Integer) {
                maxStackDepth = (Integer)configuredMaxStackDepth;
            } else if (configuredMaxStackDepth instanceof String) {
                maxStackDepth = Integer.valueOf((String)configuredMaxStackDepth);
            }
            qnames.addAll(ProcessorUtil.createWrappedElementsFromExtension(schema, type, maxStackDepth));
        }
        return qnames;
    }

    private static List<WrapperElement> createWrappedElementsFromExtension(SchemaCollection schema, XmlSchemaComplexType type, int maxStackDepth) {
        ArrayList<WrapperElement> qnames = new ArrayList<WrapperElement>();
        XmlSchemaContent schemaContent = type.getContentModel().getContent();
        if (!(schemaContent instanceof XmlSchemaComplexContentExtension) || maxStackDepth == 0) {
            return qnames;
        }
        XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)schemaContent;
        QName baseTypeName = extension.getBaseTypeName();
        XmlSchemaType baseType = schema.getTypeByQName(baseTypeName);
        if (baseType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexBaseType = (XmlSchemaComplexType)baseType;
            if (complexBaseType.getParticle() == null && complexBaseType.getContentModel() != null) {
                qnames.addAll(ProcessorUtil.createWrappedElementsFromExtension(schema, complexBaseType, maxStackDepth - 1));
            } else if (complexBaseType.getParticle() instanceof XmlSchemaSequence) {
                XmlSchemaSequence seq = (XmlSchemaSequence)complexBaseType.getParticle();
                qnames.addAll(ProcessorUtil.createWrappedElements(seq));
            }
        }
        if (extension.getParticle() instanceof XmlSchemaSequence) {
            XmlSchemaSequence xmlSchemaSeq = (XmlSchemaSequence)extension.getParticle();
            qnames.addAll(ProcessorUtil.createWrappedElements(xmlSchemaSeq));
        }
        return qnames;
    }

    private static List<WrapperElement> createWrappedElements(XmlSchemaSequence seq) {
        ArrayList<WrapperElement> qnames = new ArrayList<WrapperElement>();
        if (seq != null) {
            List items = seq.getItems();
            for (XmlSchemaSequenceMember seqMember : items) {
                XmlSchemaElement subElement = (XmlSchemaElement)seqMember;
                if (subElement.getQName() != null) {
                    qnames.add(new WrapperElement(subElement.getWireName(), subElement.getSchemaTypeName()));
                    continue;
                }
                qnames.add(new WrapperElement(subElement.getRef().getTargetQName(), subElement.getSchemaTypeName()));
            }
        }
        return qnames;
    }

    public static boolean isSchemaFormQualified(ToolContext context, QName partElement) {
        ServiceInfo serviceInfo = (ServiceInfo)context.get(ServiceInfo.class);
        SchemaCollection schemaCol = serviceInfo.getXmlSchemaCollection();
        XmlSchema schema = schemaCol.getSchemaForElement(partElement);
        if (schema != null) {
            return schema.getElementFormDefault() == XmlSchemaForm.QUALIFIED;
        }
        return false;
    }
}

