/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.management.impl.view.QueueField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.Queue;

public class QueueFilterPredicate
extends ActiveMQFilterPredicate<QueueControl> {
    private QueueField f;
    private ActiveMQServer server;

    public QueueFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean test(QueueControl queue) {
        if (this.f == null) {
            return true;
        }
        try {
            return switch (this.f) {
                case QueueField.ID -> this.matches(queue.getID());
                case QueueField.NAME -> this.matches(queue.getName());
                case QueueField.CONSUMER_ID -> {
                    Queue q = this.server.locateQueue(SimpleString.of((String)queue.getName()));
                    for (Consumer consumer : q.getConsumers()) {
                        if (!this.matches(consumer.sequentialID())) continue;
                        yield true;
                    }
                    yield false;
                }
                case QueueField.MAX_CONSUMERS -> this.matches(queue.getMaxConsumers());
                case QueueField.ADDRESS -> this.matches(queue.getAddress());
                case QueueField.FILTER -> this.matches(queue.getFilter());
                case QueueField.MESSAGE_COUNT -> this.matches(queue.getMessageCount());
                case QueueField.CONSUMER_COUNT -> this.matches(queue.getConsumerCount());
                case QueueField.DELIVERING_COUNT -> this.matches(queue.getDeliveringCount());
                case QueueField.MESSAGES_ADDED -> this.matches(queue.getMessagesAdded());
                case QueueField.MESSAGES_ACKED -> this.matches(queue.getMessagesAcknowledged());
                case QueueField.MESSAGES_EXPIRED -> this.matches(queue.getMessagesExpired());
                case QueueField.ROUTING_TYPE -> this.matches(queue.getRoutingType());
                case QueueField.AUTO_CREATED -> this.matches(this.server.locateQueue(SimpleString.of((String)queue.getName())).isAutoCreated());
                case QueueField.DURABLE -> this.matches(queue.isDurable());
                case QueueField.PAUSED -> this.matches(queue.isPaused());
                case QueueField.TEMPORARY -> this.matches(queue.isTemporary());
                case QueueField.PURGE_ON_NO_CONSUMERS -> this.matches(queue.isPurgeOnNoConsumers());
                case QueueField.MESSAGES_KILLED -> this.matches(queue.getMessagesKilled());
                case QueueField.EXCLUSIVE -> this.matches(queue.isExclusive());
                case QueueField.LAST_VALUE -> this.matches(queue.isLastValue());
                case QueueField.SCHEDULED_COUNT -> this.matches(queue.getScheduledCount());
                case QueueField.USER -> this.matches(queue.getUser());
                case QueueField.INTERNAL_QUEUE -> this.matches(queue.isInternalQueue());
                default -> true;
            };
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.isEmpty()) {
            this.f = QueueField.valueOfName(field);
            if (this.f == null) {
                this.f = QueueField.valueOf(field);
            }
        }
    }
}

