/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.ThetaAnotB;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SingleItemSketchTest {
    static final short DEFAULT_SEED_HASH = (short)((long)Util.computeSeedHash((long)9001L) & 0xFFFFL);
    static final long SiSkPre0WithSiFlag = -7796793083210562815L;
    static final long SiSkPre0WoutSiFlag = -7796828267582651647L;
    static final long Hash = 405753591161026837L;

    @Test
    public void check1() {
        ThetaUnion union = ThetaSetOperation.builder().buildUnion();
        union.union((ThetaSketch)SingleItemSketch.create((long)1L));
        union.union((ThetaSketch)SingleItemSketch.create((double)1.0));
        union.union((ThetaSketch)SingleItemSketch.create((double)0.0));
        union.union((ThetaSketch)SingleItemSketch.create((String)"1"));
        union.union((ThetaSketch)SingleItemSketch.create((byte[])new byte[]{1, 2, 3, 4}));
        union.union((ThetaSketch)SingleItemSketch.create((char[])new char[]{'a'}));
        union.union((ThetaSketch)SingleItemSketch.create((int[])new int[]{2}));
        union.union((ThetaSketch)SingleItemSketch.create((long[])new long[]{3L}));
        union.union((ThetaSketch)SingleItemSketch.create((double)-0.0));
        double est = union.getResult().getEstimate();
        SingleItemSketchTest.println("" + est);
        Assert.assertEquals((double)est, (double)8.0, (double)0.0);
        Assert.assertNull((Object)SingleItemSketch.create((String)""));
        String str = null;
        Assert.assertNull((Object)SingleItemSketch.create(str));
        Assert.assertNull((Object)SingleItemSketch.create((byte[])new byte[0]));
        byte[] byteArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(byteArr));
        Assert.assertNull((Object)SingleItemSketch.create((char[])new char[0]));
        char[] charArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(charArr));
        Assert.assertNull((Object)SingleItemSketch.create((int[])new int[0]));
        int[] intArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(intArr));
        Assert.assertNull((Object)SingleItemSketch.create((long[])new long[0]));
        long[] longArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(longArr));
    }

    @Test
    public void check2() {
        long seed = 9001L;
        ThetaUnion union = ThetaSetOperation.builder().buildUnion();
        union.union((ThetaSketch)SingleItemSketch.create((long)1L, (long)9001L));
        union.union((ThetaSketch)SingleItemSketch.create((double)1.0, (long)9001L));
        union.union((ThetaSketch)SingleItemSketch.create((double)0.0, (long)9001L));
        union.union((ThetaSketch)SingleItemSketch.create((String)"1", (long)9001L));
        union.union((ThetaSketch)SingleItemSketch.create((byte[])new byte[]{1, 2, 3, 4}, (long)9001L));
        union.union((ThetaSketch)SingleItemSketch.create((char[])new char[]{'a'}, (long)9001L));
        union.union((ThetaSketch)SingleItemSketch.create((int[])new int[]{2}, (long)9001L));
        union.union((ThetaSketch)SingleItemSketch.create((long[])new long[]{3L}, (long)9001L));
        union.union((ThetaSketch)SingleItemSketch.create((double)-0.0, (long)9001L));
        double est = union.getResult().getEstimate();
        SingleItemSketchTest.println("" + est);
        Assert.assertEquals((double)est, (double)8.0, (double)0.0);
        Assert.assertNull((Object)SingleItemSketch.create((String)"", (long)9001L));
        String str = null;
        Assert.assertNull((Object)SingleItemSketch.create(str, (long)9001L));
        Assert.assertNull((Object)SingleItemSketch.create((byte[])new byte[0], (long)9001L));
        byte[] byteArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(byteArr, (long)9001L));
        Assert.assertNull((Object)SingleItemSketch.create((char[])new char[0], (long)9001L));
        char[] charArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(charArr, (long)9001L));
        Assert.assertNull((Object)SingleItemSketch.create((int[])new int[0], (long)9001L));
        int[] intArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(intArr, (long)9001L));
        Assert.assertNull((Object)SingleItemSketch.create((long[])new long[0], (long)9001L));
        long[] longArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(longArr, (long)9001L));
    }

    @Test
    public void checkSketchInterface() {
        SingleItemSketch sis = SingleItemSketch.create((long)1L);
        Assert.assertEquals((int)sis.getCompactBytes(), (int)16);
        Assert.assertEquals((double)sis.getEstimate(), (double)1.0);
        Assert.assertEquals((double)sis.getLowerBound(1), (double)1.0);
        Assert.assertEquals((int)sis.getRetainedEntries(true), (int)1);
        Assert.assertEquals((double)sis.getUpperBound(1), (double)1.0);
        Assert.assertFalse((boolean)sis.isOffHeap());
        Assert.assertFalse((boolean)sis.hasMemorySegment());
        Assert.assertFalse((boolean)sis.isEmpty());
        Assert.assertTrue((boolean)sis.isOrdered());
    }

    @Test
    public void checkLessThanThetaLong() {
        for (int i = 0; i < 10; ++i) {
            long[] data = new long[]{i};
            long h = MurmurHash3.hash((long[])data, (long)9001L)[0] >>> 1;
            SingleItemSketch sis = SingleItemSketch.create((long)i);
            long halfMax = 0x3FFFFFFFFFFFFFFFL;
            int count = sis.getCountLessThanThetaLong(0x3FFFFFFFFFFFFFFFL);
            Assert.assertEquals((int)count, (int)(h < 0x3FFFFFFFFFFFFFFFL ? 1 : 0));
        }
    }

    @Test
    public void checkSerDe() {
        SingleItemSketch sis = SingleItemSketch.create((long)1L);
        byte[] byteArr = sis.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        short defaultSeedHash = Util.computeSeedHash((long)9001L);
        SingleItemSketch sis2 = SingleItemSketch.heapify((MemorySegment)seg, (short)defaultSeedHash);
        Assert.assertEquals((double)sis2.getEstimate(), (double)1.0);
        SingleItemSketch sis3 = SingleItemSketch.heapify((MemorySegment)seg, (short)defaultSeedHash);
        Assert.assertEquals((double)sis3.getEstimate(), (double)1.0);
        ThetaUnion union = ThetaSetOperation.builder().buildUnion();
        union.union((ThetaSketch)sis);
        union.union((ThetaSketch)sis2);
        union.union((ThetaSketch)sis3);
        CompactThetaSketch csk = union.getResult();
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)1.0);
    }

    @Test
    public void checkRestricted() {
        SingleItemSketch sis = SingleItemSketch.create((long)1L);
        Assert.assertNull((Object)sis.getMemorySegment());
        Assert.assertEquals((int)sis.getCompactPreambleLongs(), (int)1);
    }

    @Test
    public void unionWrapped() {
        SingleItemSketch sketch = SingleItemSketch.create((long)1L);
        ThetaUnion union = ThetaSetOperation.builder().buildUnion();
        MemorySegment seg = MemorySegment.ofArray(sketch.toByteArray());
        union.union(seg);
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)1.0, (double)0.0);
    }

    @Test
    public void buildAndCompact() {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(32).build();
        sk1.update(1L);
        CompactThetaSketch csk = sk1.compact(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        csk = sk1.compact(false, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        int bytes = ThetaSketch.getMaxUpdateSketchBytes((int)32);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        sk1 = UpdatableThetaSketch.builder().setNominalEntries(32).build(wseg);
        sk1.update(1L);
        csk = sk1.compact(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        csk = sk1.compact(false, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        bytes = ThetaSketch.getMaxCompactSketchBytes((int)1);
        wseg = MemorySegment.ofArray(new byte[bytes]);
        csk = sk1.compact(true, wseg);
        Assert.assertTrue((boolean)csk.isOrdered());
        csk = sk1.compact(false, wseg);
        Assert.assertTrue((boolean)csk.isOrdered());
    }

    @Test
    public void intersection() {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(32).build();
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().setNominalEntries(32).build();
        sk1.update(1L);
        sk1.update(2L);
        sk2.update(1L);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)sk1);
        inter.intersect((ThetaSketch)sk2);
        CompactThetaSketch csk = inter.getResult(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        int bytes = ThetaSetOperation.getMaxIntersectionBytes((int)32);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        inter = ThetaSetOperation.builder().buildIntersection(wseg);
        inter.intersect((ThetaSketch)sk1);
        inter.intersect((ThetaSketch)sk2);
        csk = inter.getResult(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        csk = inter.getResult(false, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
    }

    @Test
    public void union() {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(32).build();
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().setNominalEntries(32).build();
        sk1.update(1L);
        sk2.update(1L);
        ThetaUnion union = ThetaSetOperation.builder().buildUnion();
        union.union((ThetaSketch)sk1);
        union.union((ThetaSketch)sk2);
        CompactThetaSketch csk = union.getResult(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        int bytes = ThetaSetOperation.getMaxUnionBytes((int)32);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        union = ThetaSetOperation.builder().buildUnion(wseg);
        union.union((ThetaSketch)sk1);
        union.union((ThetaSketch)sk2);
        csk = union.getResult(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        csk = union.getResult(false, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
    }

    @Test
    public void aNotB() {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(32).build();
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().setNominalEntries(32).build();
        sk1.update(1L);
        sk2.update(2L);
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        aNotB.setA((ThetaSketch)sk1);
        aNotB.notB((ThetaSketch)sk2);
        CompactThetaSketch csk = aNotB.getResult(true, null, true);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
    }

    @Test
    public void checkHeapifyInstance() {
        UpdatableThetaSketch sk1 = new UpdatableThetaSketchBuilder().build();
        sk1.update(1L);
        UpdatableThetaSketch sk2 = new UpdatableThetaSketchBuilder().build();
        sk2.update(1L);
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        inter.intersect((ThetaSketch)sk1);
        inter.intersect((ThetaSketch)sk2);
        MemorySegment wseg = MemorySegment.ofArray(new byte[16]);
        CompactThetaSketch csk = inter.getResult(false, wseg);
        Assert.assertTrue((boolean)csk.isOrdered());
        ThetaSketch csk2 = ThetaSketch.heapify((MemorySegment)wseg);
        Assert.assertTrue((boolean)(csk2 instanceof SingleItemSketch));
        SingleItemSketchTest.println(csk2.toString(true, true, 1, true));
    }

    @Test
    public void checkSingleItemBadFlags() {
        short defaultSeedHash = Util.computeSeedHash((long)9001L);
        UpdatableThetaSketch sk1 = new UpdatableThetaSketchBuilder().build();
        sk1.update(1L);
        MemorySegment wseg = MemorySegment.ofArray(new byte[16]);
        sk1.compact(true, wseg);
        wseg.set(ValueLayout.JAVA_BYTE, 5L, (byte)0);
        try {
            SingleItemSketch.heapify((MemorySegment)wseg, (short)defaultSeedHash);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkDirectUnionSingleItem2() {
        ThetaSketch sk = ThetaSketch.wrap((MemorySegment)SingleItemSketchTest.siSkWoutSiFlag24Bytes());
        Assert.assertEquals((double)sk.getEstimate(), (double)1.0, (double)0.0);
        sk = ThetaSketch.wrap((MemorySegment)SingleItemSketchTest.siSkWithSiFlag24Bytes());
        Assert.assertEquals((double)sk.getEstimate(), (double)1.0, (double)0.0);
    }

    @Test
    public void checkSingleItemCompact() {
        UpdatableThetaSketch sk1 = new UpdatableThetaSketchBuilder().build();
        sk1.update(1L);
        CompactThetaSketch csk = sk1.compact();
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        CompactThetaSketch csk2 = csk.compact();
        Assert.assertEquals((Object)csk, (Object)csk2);
        CompactThetaSketch csk3 = csk.compact(true, MemorySegment.ofArray(new byte[16]));
        Assert.assertTrue((boolean)(csk3 instanceof DirectCompactSketch));
        Assert.assertEquals((int)csk2.getCurrentPreambleLongs(), (int)1);
        Assert.assertEquals((int)csk3.getCurrentPreambleLongs(), (int)1);
    }

    static MemorySegment siSkWithSiFlag24Bytes() {
        int cap = 24;
        MemorySegment wseg = MemorySegment.ofArray(new byte[24]);
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, -7796793083210562815L);
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, 405753591161026837L);
        return wseg;
    }

    static MemorySegment siSkWoutSiFlag24Bytes() {
        int cap = 24;
        MemorySegment wseg = MemorySegment.ofArray(new byte[24]);
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, -7796828267582651647L);
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, 405753591161026837L);
        return wseg;
    }

    @Test
    public void printlnTest() {
        SingleItemSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

