/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.SapTableResourceDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="SapTableResource")
public final class SapTableResourceDataset
extends Dataset {
    @JsonProperty(value="typeProperties", required=true)
    private SapTableResourceDatasetTypeProperties innerTypeProperties = new SapTableResourceDatasetTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SapTableResourceDataset.class);

    private SapTableResourceDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SapTableResourceDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SapTableResourceDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public SapTableResourceDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public SapTableResourceDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SapTableResourceDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public SapTableResourceDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public SapTableResourceDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object tableName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tableName();
    }

    public SapTableResourceDataset withTableName(Object tableName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SapTableResourceDatasetTypeProperties();
        }
        this.innerTypeProperties().withTableName(tableName);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SapTableResourceDataset"));
        }
        this.innerTypeProperties().validate();
    }
}

