/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.SnowflakeExportCopyCommand;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="SnowflakeSource")
public final class SnowflakeSource
extends CopySource {
    @JsonProperty(value="query")
    private Object query;
    @JsonProperty(value="exportSettings", required=true)
    private SnowflakeExportCopyCommand exportSettings;
    private static final ClientLogger LOGGER = new ClientLogger(SnowflakeSource.class);

    public Object query() {
        return this.query;
    }

    public SnowflakeSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    public SnowflakeExportCopyCommand exportSettings() {
        return this.exportSettings;
    }

    public SnowflakeSource withExportSettings(SnowflakeExportCopyCommand exportSettings) {
        this.exportSettings = exportSettings;
        return this;
    }

    @Override
    public SnowflakeSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SnowflakeSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SnowflakeSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SnowflakeSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.exportSettings() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property exportSettings in model SnowflakeSource"));
        }
        this.exportSettings().validate();
    }
}

