/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster.loadbalancer;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.server.master.cluster.WorkerClusters;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.IWorkerLoadBalancer;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.WorkerLoadBalancerType;
import org.jetbrains.annotations.NotNull;

public class RoundRobinWorkerLoadBalancer
implements IWorkerLoadBalancer {
    private final WorkerClusters workerClusters;
    private final AtomicInteger robinIndex = new AtomicInteger(0);

    public RoundRobinWorkerLoadBalancer(WorkerClusters workerClusters) {
        this.workerClusters = workerClusters;
    }

    @Override
    public Optional<String> select(@NotNull String workerGroup) {
        List<String> workerServerAddresses = this.workerClusters.getNormalWorkerServerAddressByGroup(workerGroup);
        if (CollectionUtils.isEmpty(workerServerAddresses)) {
            return Optional.empty();
        }
        return Optional.of(workerServerAddresses.get(this.robinIndex.getAndIncrement() % workerServerAddresses.size()));
    }

    @Override
    public WorkerLoadBalancerType getType() {
        return WorkerLoadBalancerType.ROUND_ROBIN;
    }
}

