/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class SerializedException {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static SerializedException newInstance(Throwable e) {
        SerializedException exception = Records.newRecord(SerializedException.class);
        exception.init(e);
        return exception;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void init(String var1, Throwable var2);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void init(String var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void init(Throwable var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract String getMessage();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract String getRemoteTrace();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract SerializedException getCause();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract Throwable deSerialize();

    private void stringify(StringBuilder sb) {
        sb.append(this.getMessage()).append("\n").append(this.getRemoteTrace());
        SerializedException cause = this.getCause();
        if (cause != null) {
            sb.append("Caused by: ");
            cause.stringify(sb);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        this.stringify(sb);
        return sb.toString();
    }
}

