/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AzureMLExecutePipelineActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="AzureMLExecutePipeline")
public final class AzureMLExecutePipelineActivity
extends ExecutionActivity {
    @JsonProperty(value="typeProperties", required=true)
    private AzureMLExecutePipelineActivityTypeProperties innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureMLExecutePipelineActivity.class);

    private AzureMLExecutePipelineActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureMLExecutePipelineActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object mlPipelineId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mlPipelineId();
    }

    public AzureMLExecutePipelineActivity withMlPipelineId(Object mlPipelineId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withMlPipelineId(mlPipelineId);
        return this;
    }

    public Object mlPipelineEndpointId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mlPipelineEndpointId();
    }

    public AzureMLExecutePipelineActivity withMlPipelineEndpointId(Object mlPipelineEndpointId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withMlPipelineEndpointId(mlPipelineEndpointId);
        return this;
    }

    public Object version() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().version();
    }

    public AzureMLExecutePipelineActivity withVersion(Object version) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withVersion(version);
        return this;
    }

    public Object experimentName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().experimentName();
    }

    public AzureMLExecutePipelineActivity withExperimentName(Object experimentName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withExperimentName(experimentName);
        return this;
    }

    public Object mlPipelineParameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mlPipelineParameters();
    }

    public AzureMLExecutePipelineActivity withMlPipelineParameters(Object mlPipelineParameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withMlPipelineParameters(mlPipelineParameters);
        return this;
    }

    public Object dataPathAssignments() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataPathAssignments();
    }

    public AzureMLExecutePipelineActivity withDataPathAssignments(Object dataPathAssignments) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withDataPathAssignments(dataPathAssignments);
        return this;
    }

    public Object mlParentRunId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mlParentRunId();
    }

    public AzureMLExecutePipelineActivity withMlParentRunId(Object mlParentRunId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withMlParentRunId(mlParentRunId);
        return this;
    }

    public Object continueOnStepFailure() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().continueOnStepFailure();
    }

    public AzureMLExecutePipelineActivity withContinueOnStepFailure(Object continueOnStepFailure) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withContinueOnStepFailure(continueOnStepFailure);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureMLExecutePipelineActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

