/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.implementation.VirtualNetworkGatewayImpl;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.PointToSiteConfiguration;
import com.azure.resourcemanager.network.models.VirtualNetworkGateway;
import com.azure.resourcemanager.network.models.VpnClientConfiguration;
import com.azure.resourcemanager.network.models.VpnClientProtocol;
import com.azure.resourcemanager.network.models.VpnClientRevokedCertificate;
import com.azure.resourcemanager.network.models.VpnClientRootCertificate;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;

class PointToSiteConfigurationImpl
extends IndexableWrapperImpl<VpnClientConfiguration>
implements PointToSiteConfiguration,
PointToSiteConfiguration.Definition<VirtualNetworkGateway.Update>,
PointToSiteConfiguration.Update {
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";
    private VirtualNetworkGatewayImpl parent;

    PointToSiteConfigurationImpl(VpnClientConfiguration inner, VirtualNetworkGatewayImpl parent) {
        super((Object)inner);
        this.parent = parent;
    }

    public VirtualNetworkGatewayImpl attach() {
        this.parent.attachPointToSiteConfiguration(this);
        return this.parent;
    }

    @Override
    public PointToSiteConfigurationImpl withAddressPool(String addressPool) {
        ArrayList<String> addressPrefixes = new ArrayList<String>();
        addressPrefixes.add(addressPool);
        ((VpnClientConfiguration)this.innerModel()).withVpnClientAddressPool(new AddressSpace().withAddressPrefixes(addressPrefixes));
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withAzureCertificate(String name, String certificateData) {
        if (((VpnClientConfiguration)this.innerModel()).vpnClientRootCertificates() == null) {
            ((VpnClientConfiguration)this.innerModel()).withVpnClientRootCertificates(new ArrayList<VpnClientRootCertificate>());
        }
        ((VpnClientConfiguration)this.innerModel()).vpnClientRootCertificates().add(new VpnClientRootCertificate().withName(name).withPublicCertData(certificateData));
        ((VpnClientConfiguration)this.innerModel()).withRadiusServerAddress(null).withRadiusServerSecret(null);
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withAzureCertificateFromFile(String name, File certificateFile) throws IOException {
        if (certificateFile == null) {
            return this;
        }
        byte[] content = Files.readAllBytes(certificateFile.toPath());
        String certificate = new String(content, StandardCharsets.UTF_8).replace(BEGIN_CERT, "").replace(END_CERT, "");
        return this.withAzureCertificate(name, certificate);
    }

    @Override
    public PointToSiteConfiguration.Update withoutAzureCertificate(String name) {
        if (((VpnClientConfiguration)this.innerModel()).vpnClientRootCertificates() != null) {
            for (VpnClientRootCertificate certificateInner : ((VpnClientConfiguration)this.innerModel()).vpnClientRootCertificates()) {
                if (!name.equals(certificateInner.name())) continue;
                ((VpnClientConfiguration)this.innerModel()).vpnClientRootCertificates().remove((Object)certificateInner);
                break;
            }
        }
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withRadiusAuthentication(String serverIPAddress, String serverSecret) {
        ((VpnClientConfiguration)this.innerModel()).withRadiusServerAddress(serverIPAddress).withRadiusServerSecret(serverSecret);
        ((VpnClientConfiguration)this.innerModel()).withVpnClientRootCertificates(null);
        ((VpnClientConfiguration)this.innerModel()).withVpnClientRevokedCertificates(null);
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withRevokedCertificate(String name, String thumbprint) {
        if (((VpnClientConfiguration)this.innerModel()).vpnClientRevokedCertificates() == null) {
            ((VpnClientConfiguration)this.innerModel()).withVpnClientRevokedCertificates(new ArrayList<VpnClientRevokedCertificate>());
        }
        ((VpnClientConfiguration)this.innerModel()).vpnClientRevokedCertificates().add(new VpnClientRevokedCertificate().withName(name).withThumbprint(thumbprint));
        ((VpnClientConfiguration)this.innerModel()).withRadiusServerAddress(null).withRadiusServerSecret(null);
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withSstpOnly() {
        ((VpnClientConfiguration)this.innerModel()).withVpnClientProtocols(Collections.singletonList(VpnClientProtocol.SSTP));
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withIkeV2Only() {
        ((VpnClientConfiguration)this.innerModel()).withVpnClientProtocols(Collections.singletonList(VpnClientProtocol.IKE_V2));
        return this;
    }

    public VirtualNetworkGateway.Update parent() {
        return this.parent;
    }
}

