/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.resourcemanager.appservice.implementation.AppServiceDomainImpl;
import com.azure.resourcemanager.appservice.models.Address;
import com.azure.resourcemanager.appservice.models.AppServiceDomain;
import com.azure.resourcemanager.appservice.models.Contact;
import com.azure.resourcemanager.appservice.models.DomainContact;
import com.azure.resourcemanager.resources.fluentcore.arm.CountryIsoCode;
import com.azure.resourcemanager.resources.fluentcore.arm.CountryPhoneCode;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

class DomainContactImpl
extends ChildResourceImpl<Contact, AppServiceDomainImpl, AppServiceDomain>
implements DomainContact,
DomainContact.Definition<AppServiceDomain.DefinitionStages.WithCreate> {
    DomainContactImpl(Contact inner, AppServiceDomainImpl parent) {
        super((Object)inner, (Object)parent);
        ((Contact)this.innerModel()).withAddressMailing(new Address());
    }

    public String name() {
        return this.firstName() + " " + this.lastName();
    }

    @Override
    public Address addressMailing() {
        return ((Contact)this.innerModel()).addressMailing();
    }

    @Override
    public String email() {
        return ((Contact)this.innerModel()).email();
    }

    @Override
    public String fax() {
        return ((Contact)this.innerModel()).fax();
    }

    @Override
    public String jobTitle() {
        return ((Contact)this.innerModel()).jobTitle();
    }

    @Override
    public String firstName() {
        return ((Contact)this.innerModel()).nameFirst();
    }

    @Override
    public String lastName() {
        return ((Contact)this.innerModel()).nameLast();
    }

    @Override
    public String middleName() {
        return ((Contact)this.innerModel()).nameMiddle();
    }

    @Override
    public String organization() {
        return ((Contact)this.innerModel()).organization();
    }

    @Override
    public String phone() {
        return ((Contact)this.innerModel()).phone();
    }

    public AppServiceDomainImpl attach() {
        return ((AppServiceDomainImpl)this.parent()).withRegistrantContact((Contact)this.innerModel());
    }

    public DomainContactImpl withFirstName(String firstName) {
        ((Contact)this.innerModel()).withNameFirst(firstName);
        return this;
    }

    public DomainContactImpl withMiddleName(String middleName) {
        ((Contact)this.innerModel()).withNameMiddle(middleName);
        return this;
    }

    public DomainContactImpl withLastName(String lastName) {
        ((Contact)this.innerModel()).withNameLast(lastName);
        return this;
    }

    public DomainContactImpl withEmail(String email) {
        ((Contact)this.innerModel()).withEmail(email);
        return this;
    }

    public DomainContactImpl withAddressLine1(String addressLine1) {
        ((Contact)this.innerModel()).addressMailing().withAddress1(addressLine1);
        return this;
    }

    public DomainContactImpl withAddressLine2(String addressLine2) {
        ((Contact)this.innerModel()).addressMailing().withAddress2(addressLine2);
        return this;
    }

    public DomainContactImpl withCity(String city) {
        ((Contact)this.innerModel()).addressMailing().withCity(city);
        return this;
    }

    public DomainContactImpl withStateOrProvince(String stateOrProvince) {
        ((Contact)this.innerModel()).addressMailing().withState(stateOrProvince);
        return this;
    }

    public DomainContactImpl withCountry(CountryIsoCode country) {
        ((Contact)this.innerModel()).addressMailing().withCountry(country.toString());
        return this;
    }

    public DomainContactImpl withPostalCode(String postalCode) {
        ((Contact)this.innerModel()).addressMailing().withPostalCode(postalCode);
        return this;
    }

    public DomainContactImpl withPhoneCountryCode(CountryPhoneCode code) {
        ((Contact)this.innerModel()).withPhone(code.toString() + ".");
        return this;
    }

    public DomainContactImpl withPhoneNumber(String phoneNumber) {
        ((Contact)this.innerModel()).withPhone(((Contact)this.innerModel()).phone() + phoneNumber);
        return this;
    }

    public DomainContactImpl withFaxNumber(String faxNumber) {
        ((Contact)this.innerModel()).withFax(faxNumber);
        return this;
    }

    public DomainContactImpl withOrganization(String organziation) {
        ((Contact)this.innerModel()).withOrganization(organziation);
        return this;
    }

    public DomainContactImpl withJobTitle(String jobTitle) {
        ((Contact)this.innerModel()).withJobTitle(jobTitle);
        return this;
    }

    @Override
    public Contact build() {
        return (Contact)this.innerModel();
    }
}

