/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.ActionList;
import com.azure.resourcemanager.monitor.models.ActivityLogAlertAllOfCondition;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AlertRuleProperties {
    @JsonProperty(value="scopes", required=true)
    private List<String> scopes;
    @JsonProperty(value="condition", required=true)
    private ActivityLogAlertAllOfCondition condition;
    @JsonProperty(value="actions", required=true)
    private ActionList actions;
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="description")
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(AlertRuleProperties.class);

    public List<String> scopes() {
        return this.scopes;
    }

    public AlertRuleProperties withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public ActivityLogAlertAllOfCondition condition() {
        return this.condition;
    }

    public AlertRuleProperties withCondition(ActivityLogAlertAllOfCondition condition) {
        this.condition = condition;
        return this;
    }

    public ActionList actions() {
        return this.actions;
    }

    public AlertRuleProperties withActions(ActionList actions) {
        this.actions = actions;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public AlertRuleProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String description() {
        return this.description;
    }

    public AlertRuleProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.scopes() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property scopes in model AlertRuleProperties"));
        }
        if (this.condition() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property condition in model AlertRuleProperties"));
        }
        this.condition().validate();
        if (this.actions() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property actions in model AlertRuleProperties"));
        }
        this.actions().validate();
    }
}

