/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.serial;

import java.io.Serializable;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.model.SerialCommandDto;
import org.apache.dolphinscheduler.dao.repository.CommandDao;
import org.apache.dolphinscheduler.dao.repository.SerialCommandDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.IWorkflowControlClient;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceStopRequest;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.engine.workflow.serial.ISerialCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractSerialCommandHandler
implements ISerialCommandHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSerialCommandHandler.class);
    @Autowired
    protected WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    protected IWorkflowControlClient workflowControlClient;
    @Autowired
    protected TransactionTemplate transactionTemplate;
    @Autowired
    protected MasterConfig masterConfig;
    @Autowired
    protected CommandDao commandDao;
    @Autowired
    protected SerialCommandDao serialCommandDao;

    protected void launchSerialCommand(final SerialCommandDto serialCommand) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Void doInTransaction(TransactionStatus status) {
                Command command = serialCommand.getCommand();
                AbstractSerialCommandHandler.this.commandDao.insert((Object)command);
                serialCommand.setState(SerialCommandDto.State.LAUNCHED);
                AbstractSerialCommandHandler.this.serialCommandDao.updateById((Object)serialCommand.toEntity());
                return null;
            }
        });
    }

    protected void discardSerialCommandAndStopWorkflowInstanceInDB(final SerialCommandDto serialCommand) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Void doInTransaction(TransactionStatus status) {
                AbstractSerialCommandHandler.this.serialCommandDao.deleteById((Serializable)serialCommand.getId());
                Integer workflowInstanceId = serialCommand.getWorkflowInstanceId();
                WorkflowInstance workflowInstance = (WorkflowInstance)AbstractSerialCommandHandler.this.workflowInstanceDao.queryById((Serializable)workflowInstanceId);
                workflowInstance.setState(WorkflowExecutionStatus.STOP);
                AbstractSerialCommandHandler.this.workflowInstanceDao.upsertWorkflowInstance(workflowInstance);
                return null;
            }
        });
    }

    protected void stopWorkflowInstanceInMaster(SerialCommandDto serialCommand) {
        Integer workflowInstanceId = serialCommand.getWorkflowInstanceId();
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryById((Serializable)workflowInstanceId);
        if (!workflowInstance.getState().isCanStop()) {
            return;
        }
        String workflowInstanceLaunchedHost = workflowInstance.getHost();
        WorkflowInstanceStopRequest stopRequest = new WorkflowInstanceStopRequest(workflowInstanceId);
        if (this.masterConfig.getMasterAddress().equals(workflowInstanceLaunchedHost)) {
            this.workflowControlClient.stopWorkflowInstance(stopRequest);
        } else {
            ((IWorkflowControlClient)Clients.withService(IWorkflowControlClient.class).withHost(workflowInstanceLaunchedHost)).stopWorkflowInstance(stopRequest);
        }
    }
}

