/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.search.SearchServiceManager;
import com.azure.resourcemanager.search.fluent.SearchManagementClient;
import com.azure.resourcemanager.search.fluent.models.SearchServiceInner;
import com.azure.resourcemanager.search.implementation.AdminKeysImpl;
import com.azure.resourcemanager.search.implementation.QueryKeyImpl;
import com.azure.resourcemanager.search.models.AdminKeyKind;
import com.azure.resourcemanager.search.models.AdminKeys;
import com.azure.resourcemanager.search.models.HostingMode;
import com.azure.resourcemanager.search.models.ProvisioningState;
import com.azure.resourcemanager.search.models.QueryKey;
import com.azure.resourcemanager.search.models.SearchService;
import com.azure.resourcemanager.search.models.SearchServiceStatus;
import com.azure.resourcemanager.search.models.Sku;
import com.azure.resourcemanager.search.models.SkuName;
import reactor.core.publisher.Mono;

class SearchServiceImpl
extends GroupableParentResourceImpl<SearchService, SearchServiceInner, SearchServiceImpl, SearchServiceManager>
implements SearchService,
SearchService.Definition,
SearchService.Update {
    SearchServiceImpl(String name, SearchServiceInner innerModel, SearchServiceManager searchManager) {
        super(name, (Resource)innerModel, (Manager)searchManager);
    }

    protected Mono<SearchServiceInner> createInner() {
        return ((SearchManagementClient)((SearchServiceManager)this.manager()).serviceClient()).getServices().createOrUpdateAsync(this.resourceGroupName(), this.name(), (SearchServiceInner)((Object)this.innerModel())).switchIfEmpty(((SearchManagementClient)((SearchServiceManager)this.manager()).serviceClient()).getServices().getByResourceGroupAsync(this.resourceGroupName(), this.name()));
    }

    protected void initializeChildrenFromInner() {
    }

    protected Mono<SearchServiceInner> getInnerAsync() {
        return ((SearchManagementClient)((SearchServiceManager)this.manager()).serviceClient()).getServices().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public HostingMode hostingMode() {
        return ((SearchServiceInner)((Object)this.innerModel())).hostingMode();
    }

    @Override
    public int partitionCount() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((SearchServiceInner)((Object)this.innerModel())).partitionCount());
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((SearchServiceInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public int replicaCount() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((SearchServiceInner)((Object)this.innerModel())).replicaCount());
    }

    @Override
    public Sku sku() {
        return ((SearchServiceInner)((Object)this.innerModel())).sku();
    }

    @Override
    public SearchServiceStatus status() {
        return ((SearchServiceInner)((Object)this.innerModel())).status();
    }

    @Override
    public String statusDetails() {
        return ((SearchServiceInner)((Object)this.innerModel())).statusDetails();
    }

    @Override
    public AdminKeys getAdminKeys() {
        return (AdminKeys)this.getAdminKeysAsync().block();
    }

    @Override
    public Mono<AdminKeys> getAdminKeysAsync() {
        return ((SearchManagementClient)((SearchServiceManager)this.manager()).serviceClient()).getAdminKeys().getAsync(this.resourceGroupName(), this.name()).map(AdminKeysImpl::new);
    }

    @Override
    public PagedIterable<QueryKey> listQueryKeys() {
        return new PagedIterable(this.listQueryKeysAsync());
    }

    @Override
    public PagedFlux<QueryKey> listQueryKeysAsync() {
        return PagedConverter.mapPage(((SearchManagementClient)((SearchServiceManager)this.manager()).serviceClient()).getQueryKeys().listBySearchServiceAsync(this.resourceGroupName(), this.name()), QueryKeyImpl::new);
    }

    @Override
    public AdminKeys regenerateAdminKeys(AdminKeyKind keyKind) {
        return (AdminKeys)this.regenerateAdminKeysAsync(keyKind).block();
    }

    @Override
    public Mono<AdminKeys> regenerateAdminKeysAsync(AdminKeyKind keyKind) {
        return ((SearchManagementClient)((SearchServiceManager)this.manager()).serviceClient()).getAdminKeys().regenerateAsync(this.resourceGroupName(), this.name(), keyKind).map(AdminKeysImpl::new);
    }

    @Override
    public QueryKey createQueryKey(String name) {
        return (QueryKey)this.createQueryKeyAsync(name).block();
    }

    @Override
    public Mono<QueryKey> createQueryKeyAsync(String name) {
        return ((SearchManagementClient)((SearchServiceManager)this.manager()).serviceClient()).getQueryKeys().createAsync(this.resourceGroupName(), this.name(), name).map(QueryKeyImpl::new);
    }

    @Override
    public void deleteQueryKey(String key) {
        this.deleteQueryKeyAsync(key).block();
    }

    @Override
    public Mono<Void> deleteQueryKeyAsync(String key) {
        return ((SearchManagementClient)((SearchServiceManager)this.manager()).serviceClient()).getQueryKeys().deleteAsync(this.resourceGroupName(), this.name(), key);
    }

    @Override
    public SearchServiceImpl withSku(SkuName skuName) {
        ((SearchServiceInner)((Object)this.innerModel())).withSku(new Sku().withName(skuName));
        return this;
    }

    @Override
    public SearchServiceImpl withFreeSku() {
        ((SearchServiceInner)((Object)this.innerModel())).withSku(new Sku().withName(SkuName.FREE));
        return this;
    }

    @Override
    public SearchServiceImpl withBasicSku() {
        ((SearchServiceInner)((Object)this.innerModel())).withSku(new Sku().withName(SkuName.BASIC));
        return this;
    }

    @Override
    public SearchServiceImpl withStandardSku() {
        ((SearchServiceInner)((Object)this.innerModel())).withSku(new Sku().withName(SkuName.STANDARD));
        return this;
    }

    @Override
    public SearchServiceImpl withReplicaCount(int count) {
        ((SearchServiceInner)((Object)this.innerModel())).withReplicaCount(count);
        return this;
    }

    @Override
    public SearchServiceImpl withPartitionCount(int count) {
        ((SearchServiceInner)((Object)this.innerModel())).withPartitionCount(count);
        return this;
    }
}

