/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.http.HttpRequest;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;

public class InterceptorRetryPolicy
implements RetryPolicy {
    private final HttpRequest request;
    private final LoadBalancedRetryPolicy policy;
    private final ServiceInstanceChooser serviceInstanceChooser;
    private final String serviceName;

    public InterceptorRetryPolicy(HttpRequest request, LoadBalancedRetryPolicy policy, ServiceInstanceChooser serviceInstanceChooser, String serviceName) {
        this.request = request;
        this.policy = policy;
        this.serviceInstanceChooser = serviceInstanceChooser;
        this.serviceName = serviceName;
    }

    public boolean canRetry(RetryContext context) {
        LoadBalancedRetryContext lbContext = (LoadBalancedRetryContext)context;
        if (lbContext.getRetryCount() == 0 && lbContext.getServiceInstance() == null) {
            lbContext.setServiceInstance(null);
            return true;
        }
        return this.policy.canRetryNextServer(lbContext);
    }

    public RetryContext open(RetryContext parent) {
        return new LoadBalancedRetryContext(parent, this.request);
    }

    public void close(RetryContext context) {
        this.policy.close((LoadBalancedRetryContext)context);
    }

    public void registerThrowable(RetryContext context, Throwable throwable) {
        LoadBalancedRetryContext lbContext = (LoadBalancedRetryContext)context;
        lbContext.registerThrowable(throwable);
        this.policy.registerThrowable(lbContext, throwable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterceptorRetryPolicy that = (InterceptorRetryPolicy)o;
        if (!this.request.equals(that.request)) {
            return false;
        }
        if (!this.policy.equals(that.policy)) {
            return false;
        }
        if (!this.serviceInstanceChooser.equals(that.serviceInstanceChooser)) {
            return false;
        }
        return this.serviceName.equals(that.serviceName);
    }

    public int hashCode() {
        int result = this.request.hashCode();
        result = 31 * result + this.policy.hashCode();
        result = 31 * result + this.serviceInstanceChooser.hashCode();
        result = 31 * result + this.serviceName.hashCode();
        return result;
    }
}

