/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchHolder;
import org.apache.druid.segment.ColumnValueSelector;

public class HllSketchMergeAggregator
implements Aggregator {
    private final ColumnValueSelector<HllSketchHolder> selector;
    private final TgtHllType tgtHllType;
    private Union union;

    public HllSketchMergeAggregator(ColumnValueSelector<HllSketchHolder> selector, int lgK, TgtHllType tgtHllType) {
        this.selector = selector;
        this.tgtHllType = tgtHllType;
        this.union = new Union(lgK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate() {
        HllSketchHolder sketch = (HllSketchHolder)this.selector.getObject();
        if (sketch == null) {
            return;
        }
        HllSketchMergeAggregator hllSketchMergeAggregator = this;
        synchronized (hllSketchMergeAggregator) {
            this.union.update(sketch.getSketch());
        }
    }

    public synchronized Object get() {
        return HllSketchHolder.of(this.union.getResult(this.tgtHllType));
    }

    public void close() {
        this.union = null;
    }

    public float getFloat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

