/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchHolder;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class HllSketchToEstimateWithBoundsPostAggregator
implements PostAggregator {
    public static final int DEFAULT_NUM_STD_DEVS = 1;
    private final String name;
    private final PostAggregator field;
    private final int numStdDevs;

    @JsonCreator
    public HllSketchToEstimateWithBoundsPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="numStdDev") @Nullable Integer numStdDevs) {
        this.name = name;
        this.field = field;
        this.numStdDevs = numStdDevs == null ? 1 : numStdDevs;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.DOUBLE_ARRAY;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    @JsonProperty
    public int getNumStdDev() {
        return this.numStdDevs;
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public Comparator<double[]> getComparator() {
        throw new IAE("Comparing arrays of estimates and error bounds is not supported", new Object[0]);
    }

    public double[] compute(Map<String, Object> combinedAggregators) {
        Object hllSketchHolderObject = this.field.compute(combinedAggregators);
        if (hllSketchHolderObject == null) {
            return new double[]{0.0, 0.0, 0.0};
        }
        HllSketchHolder sketch = HllSketchHolder.fromObj(hllSketchHolderObject);
        return new double[]{sketch.getEstimate(), sketch.getLowerBound(this.numStdDevs), sketch.getUpperBound(this.numStdDevs)};
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(50).appendString(this.name).appendCacheable((Cacheable)this.field).appendInt(this.numStdDevs).build();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "', field=" + String.valueOf(this.field) + ", numStdDev=" + this.numStdDevs + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HllSketchToEstimateWithBoundsPostAggregator that = (HllSketchToEstimateWithBoundsPostAggregator)o;
        return this.numStdDevs == that.numStdDevs && this.name.equals(that.name) && this.field.equals(that.field);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.field, this.numStdDevs);
    }
}

