/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.coordinator.CoordinatorClientImpl;
import org.apache.druid.client.selector.HistoricalFilter;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.CloneQueryMode;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;

public class BrokerViewOfCoordinatorConfig
implements HistoricalFilter {
    private static final Logger log = new Logger(BrokerViewOfCoordinatorConfig.class);
    private final CoordinatorClient coordinatorClient;
    @GuardedBy(value="this")
    private CoordinatorDynamicConfig config;
    @GuardedBy(value="this")
    private Set<String> targetCloneServers;
    @GuardedBy(value="this")
    private Set<String> sourceCloneServers;

    @Inject
    public BrokerViewOfCoordinatorConfig(@Json ObjectMapper jsonMapper, @EscalatedGlobal ServiceClientFactory clientFactory, @Coordinator ServiceLocator serviceLocator) {
        this.coordinatorClient = new CoordinatorClientImpl(clientFactory.makeClient(NodeRole.COORDINATOR.getJsonName(), serviceLocator, StandardRetryPolicy.builder().maxAttempts(15L).build()), jsonMapper);
    }

    @VisibleForTesting
    public BrokerViewOfCoordinatorConfig(CoordinatorClient coordinatorClient) {
        this.coordinatorClient = coordinatorClient;
    }

    public synchronized CoordinatorDynamicConfig getDynamicConfig() {
        return this.config;
    }

    public synchronized void setDynamicConfig(@NotNull CoordinatorDynamicConfig updatedConfig) {
        this.config = updatedConfig;
        Map<String, String> cloneServers = this.config.getCloneServers();
        this.targetCloneServers = ImmutableSet.copyOf(cloneServers.keySet());
        this.sourceCloneServers = ImmutableSet.copyOf(cloneServers.values());
    }

    @LifecycleStart
    public void start() {
        try {
            log.info("Fetching coordinator dynamic configuration.", new Object[0]);
            CoordinatorDynamicConfig coordinatorDynamicConfig = (CoordinatorDynamicConfig)this.coordinatorClient.getCoordinatorDynamicConfig().get();
            this.setDynamicConfig(coordinatorDynamicConfig);
            log.info("Successfully fetched coordinator dynamic config[%s].", new Object[]{coordinatorDynamicConfig});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize coordinator dynamic config", e);
        }
    }

    @Override
    public Int2ObjectRBTreeMap<Set<QueryableDruidServer>> getQueryableServers(Int2ObjectRBTreeMap<Set<QueryableDruidServer>> historicalServers, CloneQueryMode mode) {
        Set<String> serversToIgnore = this.getCurrentServersToIgnore(mode);
        if (serversToIgnore.isEmpty()) {
            return historicalServers;
        }
        Int2ObjectRBTreeMap filteredHistoricals = new Int2ObjectRBTreeMap();
        IntBidirectionalIterator intBidirectionalIterator = historicalServers.keySet().iterator();
        while (intBidirectionalIterator.hasNext()) {
            int priority = (Integer)intBidirectionalIterator.next();
            Set servers = (Set)historicalServers.get(priority);
            filteredHistoricals.put(priority, servers.stream().filter(server -> !serversToIgnore.contains(server.getServer().getHost())).collect(Collectors.toSet()));
        }
        return filteredHistoricals;
    }

    private synchronized Set<String> getCurrentServersToIgnore(CloneQueryMode cloneQueryMode) {
        switch (cloneQueryMode) {
            case PREFERCLONES: {
                return this.sourceCloneServers;
            }
            case EXCLUDECLONES: {
                return this.targetCloneServers;
            }
            case INCLUDECLONES: {
                return Set.of();
            }
        }
        throw DruidException.defensive((String)"Unexpected value of cloneQueryMode[%s]", (Object[])new Object[]{cloneQueryMode});
    }
}

