/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class MessageBatch<T> {
    private final List<T> messages;
    private final long epoch;
    private final long startWatermark;

    @JsonCreator
    public MessageBatch(@JsonProperty(value="messages") List<T> messages, @JsonProperty(value="epoch") long epoch, @JsonProperty(value="watermark") long startWatermark) {
        this.messages = messages;
        this.epoch = epoch;
        this.startWatermark = startWatermark;
    }

    @JsonProperty
    public List<T> getMessages() {
        return this.messages;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public long getEpoch() {
        return this.epoch;
    }

    @JsonProperty(value="watermark")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public long getStartWatermark() {
        return this.startWatermark;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageBatch that = (MessageBatch)o;
        return this.epoch == that.epoch && this.startWatermark == that.startWatermark && Objects.equals(this.messages, that.messages);
    }

    public int hashCode() {
        return Objects.hash(this.messages, this.epoch, this.startWatermark);
    }

    public String toString() {
        return "MessageBatch{messages=" + String.valueOf(this.messages) + ", epoch=" + this.epoch + ", startWatermark=" + this.startWatermark + "}";
    }
}

