/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SegmentMetadata;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;

public class SqlSegmentsMetadataManager
implements SegmentsMetadataManager {
    private static final EmittingLogger log = new EmittingLogger(SqlSegmentsMetadataManager.class);
    private final ReentrantReadWriteLock startStopPollLock = new ReentrantReadWriteLock();
    private final Object pollLock = new Object();
    private final ObjectMapper jsonMapper;
    private final ObjectReader segmentReader;
    private final Duration periodicPollDelay;
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final SQLMetadataConnector connector;
    private final SegmentSchemaCache segmentSchemaCache;
    private final ServiceEmitter serviceEmitter;
    private final CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig;
    private volatile @MonotonicNonNull DataSourcesSnapshot dataSourcesSnapshot = null;
    @Nullable
    private volatile DatabasePoll latestDatabasePoll = null;
    @Nullable
    @GuardedBy(value="startStopPollLock")
    private Future<?> periodicPollTaskFuture = null;
    @GuardedBy(value="startStopPollLock")
    private long startPollingCount = 0L;
    @GuardedBy(value="startStopPollLock")
    private long currentStartPollingOrder = -1L;
    @Nullable
    @GuardedBy(value="startStopPollLock")
    private ScheduledExecutorService exec = null;
    private Future<?> usedFlagLastUpdatedPopulationFuture;

    public SqlSegmentsMetadataManager(ObjectMapper jsonMapper, Supplier<SegmentsMetadataManagerConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, SQLMetadataConnector connector, SegmentSchemaCache segmentSchemaCache, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig, ServiceEmitter serviceEmitter) {
        this.jsonMapper = jsonMapper;
        this.segmentReader = jsonMapper.readerFor(DataSegment.class);
        this.periodicPollDelay = ((SegmentsMetadataManagerConfig)config.get()).getPollDuration().toStandardDuration();
        this.dbTables = dbTables;
        this.connector = connector;
        this.segmentSchemaCache = segmentSchemaCache;
        this.centralizedDatasourceSchemaConfig = centralizedDatasourceSchemaConfig;
        this.serviceEmitter = serviceEmitter;
    }

    @Override
    public void start() {
        ReentrantReadWriteLock.WriteLock lock = this.startStopPollLock.writeLock();
        lock.lock();
        try {
            if (this.exec != null) {
                return;
            }
            this.exec = Execs.scheduledSingleThreaded((String)(StringUtils.encodeForFormat((String)this.getClass().getName()) + "-Exec--%d"));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void stop() {
        ReentrantReadWriteLock.WriteLock lock = this.startStopPollLock.writeLock();
        lock.lock();
        try {
            this.exec.shutdownNow();
            this.exec = null;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startPollingDatabasePeriodically() {
        ReentrantReadWriteLock.WriteLock lock = this.startStopPollLock.writeLock();
        lock.lock();
        try {
            if (this.exec == null) {
                throw new IllegalStateException(this.getClass().getName() + " is not started");
            }
            if (this.isPollingDatabasePeriodically()) {
                return;
            }
            PeriodicDatabasePoll periodicDatabasePoll = new PeriodicDatabasePoll();
            this.latestDatabasePoll = periodicDatabasePoll;
            ++this.startPollingCount;
            long localStartOrder = this.currentStartPollingOrder = this.startPollingCount;
            this.periodicPollTaskFuture = this.exec.scheduleWithFixedDelay(this.createPollTaskForStartOrder(localStartOrder, periodicDatabasePoll), 0L, this.periodicPollDelay.getMillis(), TimeUnit.MILLISECONDS);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void stopAsyncUsedFlagLastUpdatedUpdate() {
        if (!this.usedFlagLastUpdatedPopulationFuture.isDone() && !this.usedFlagLastUpdatedPopulationFuture.isCancelled()) {
            this.usedFlagLastUpdatedPopulationFuture.cancel(true);
        }
    }

    @Override
    public void populateUsedFlagLastUpdatedAsync() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        this.usedFlagLastUpdatedPopulationFuture = executorService.submit(this::populateUsedFlagLastUpdated);
    }

    @VisibleForTesting
    void populateUsedFlagLastUpdated() {
        String segmentsTable = this.getSegmentsTable();
        log.info("Populating column 'used_status_last_updated' with non-NULL values for unused segments in table[%s].", new Object[]{segmentsTable});
        int batchSize = 100;
        int totalUpdatedEntries = 0;
        while (true) {
            int numUpdatedRows;
            ArrayList segmentsToUpdate = new ArrayList(100);
            try {
                this.connector.retryWithHandle(handle -> {
                    segmentsToUpdate.addAll(((Query)handle.createQuery(StringUtils.format((String)"SELECT id FROM %1$s WHERE used_status_last_updated IS NULL and used = :used %2$s", (Object[])new Object[]{segmentsTable, this.connector.limitClause(100)})).bind("used", false)).mapTo(String.class).list());
                    return null;
                });
                if (segmentsToUpdate.isEmpty()) break;
                numUpdatedRows = (Integer)this.connector.retryWithHandle(handle -> {
                    Batch updateBatch = handle.createBatch();
                    String sql = "UPDATE %1$s SET used_status_last_updated = '%2$s' WHERE id = '%3$s'";
                    String now = DateTimes.nowUtc().toString();
                    for (String id : segmentsToUpdate) {
                        updateBatch.add(StringUtils.format((String)"UPDATE %1$s SET used_status_last_updated = '%2$s' WHERE id = '%3$s'", (Object[])new Object[]{segmentsTable, now, id}));
                    }
                    int[] results = updateBatch.execute();
                    return Arrays.stream(results).sum();
                });
                totalUpdatedEntries += numUpdatedRows;
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Populating column 'used_status_last_updated' in table[%s] has failed. There may be unused segments with NULL values for 'used_status_last_updated' that won't be killed!", new Object[]{segmentsTable});
                return;
            }
            log.debug("Updated a batch of [%d] rows in table[%s] with a valid used_status_last_updated date", new Object[]{segmentsToUpdate.size(), segmentsTable});
            if (segmentsToUpdate.size() == numUpdatedRows && numUpdatedRows < 100) break;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                log.info("Interrupted, exiting!", new Object[0]);
                Thread.currentThread().interrupt();
            }
        }
        log.info("Populated column 'used_status_last_updated' in table[%s] in [%d] rows.", new Object[]{segmentsTable, totalUpdatedEntries});
    }

    private Runnable createPollTaskForStartOrder(long startOrder, PeriodicDatabasePoll periodicDatabasePoll) {
        return () -> {
            try {
                long periodicPollDelayNanos = TimeUnit.MILLISECONDS.toNanos(this.periodicPollDelay.getMillis());
                while (this.latestDatabasePoll != null && this.latestDatabasePoll instanceof OnDemandDatabasePoll && ((OnDemandDatabasePoll)this.latestDatabasePoll).nanosElapsedFromInitiation() < periodicPollDelayNanos) {
                    long sleepNano = periodicPollDelayNanos - ((OnDemandDatabasePoll)this.latestDatabasePoll).nanosElapsedFromInitiation();
                    TimeUnit.NANOSECONDS.sleep(sleepNano);
                }
            }
            catch (Exception e) {
                log.debug((Throwable)e, "Exception found while waiting for next periodic poll", new Object[0]);
            }
            ReentrantReadWriteLock.ReadLock lock = this.startStopPollLock.readLock();
            lock.lock();
            try {
                if (startOrder == this.currentStartPollingOrder) {
                    periodicDatabasePoll.lastPollStartTimestampInMs = System.currentTimeMillis();
                    this.poll();
                    periodicDatabasePoll.firstPollCompletionFuture.complete(null);
                    this.latestDatabasePoll = periodicDatabasePoll;
                } else {
                    log.debug("startOrder = currentStartPollingOrder = %d, skipping poll()", new Object[]{startOrder});
                }
            }
            catch (Throwable t) {
                log.makeAlert(t, "Uncaught exception in %s's polling thread", new Object[]{SqlSegmentsMetadataManager.class}).emit();
                if (!(t instanceof Exception)) {
                    periodicDatabasePoll.firstPollCompletionFuture.completeExceptionally(t);
                    throw t;
                }
            }
            finally {
                lock.unlock();
            }
        };
    }

    @Override
    public boolean isPollingDatabasePeriodically() {
        ReentrantReadWriteLock.ReadLock lock = this.startStopPollLock.readLock();
        lock.lock();
        try {
            boolean bl = this.currentStartPollingOrder >= 0L;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void stopPollingDatabasePeriodically() {
        ReentrantReadWriteLock.WriteLock lock = this.startStopPollLock.writeLock();
        lock.lock();
        try {
            if (!this.isPollingDatabasePeriodically()) {
                return;
            }
            this.periodicPollTaskFuture.cancel(false);
            this.latestDatabasePoll = null;
            this.currentStartPollingOrder = -1L;
        }
        finally {
            lock.unlock();
        }
    }

    private void useLatestIfWithinDelayOrPerformNewDatabasePoll() {
        if (this.useLatestSnapshotIfWithinDelay()) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.startStopPollLock.writeLock();
        lock.lock();
        try {
            if (this.useLatestSnapshotIfWithinDelay()) {
                return;
            }
            OnDemandDatabasePoll onDemandDatabasePoll = new OnDemandDatabasePoll();
            this.latestDatabasePoll = onDemandDatabasePoll;
            this.doOnDemandPoll(onDemandDatabasePoll);
        }
        finally {
            lock.unlock();
        }
    }

    @VisibleForTesting
    boolean useLatestSnapshotIfWithinDelay() {
        DatabasePoll latestDatabasePoll = this.latestDatabasePoll;
        if (latestDatabasePoll instanceof PeriodicDatabasePoll) {
            Futures.getUnchecked(((PeriodicDatabasePoll)latestDatabasePoll).firstPollCompletionFuture);
            return true;
        }
        if (latestDatabasePoll instanceof OnDemandDatabasePoll) {
            boolean latestDatabasePollIsFresh;
            long periodicPollDelayNanos = TimeUnit.MILLISECONDS.toNanos(this.periodicPollDelay.getMillis());
            OnDemandDatabasePoll latestOnDemandPoll = (OnDemandDatabasePoll)latestDatabasePoll;
            boolean bl = latestDatabasePollIsFresh = latestOnDemandPoll.nanosElapsedFromInitiation() < periodicPollDelayNanos;
            if (latestDatabasePollIsFresh) {
                Futures.getUnchecked(latestOnDemandPoll.pollCompletionFuture);
                return true;
            }
        } else assert (latestDatabasePoll == null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    void forceOrWaitOngoingDatabasePoll() {
        block8: {
            long checkStartTime = System.currentTimeMillis();
            ReentrantReadWriteLock.WriteLock lock = this.startStopPollLock.writeLock();
            lock.lock();
            DatabasePoll latestDatabasePoll = this.latestDatabasePoll;
            try {
                if (latestDatabasePoll instanceof PeriodicDatabasePoll && ((PeriodicDatabasePoll)latestDatabasePoll).lastPollStartTimestampInMs > checkStartTime) {
                    lock.unlock();
                    return;
                }
            }
            catch (Exception e) {
                log.debug((Throwable)e, "Latest poll was unsuccessful. Starting a new poll...", new Object[0]);
                break block8;
            }
            {
                if (!(latestDatabasePoll instanceof OnDemandDatabasePoll)) break block8;
                long checkStartTimeNanos = TimeUnit.MILLISECONDS.toNanos(checkStartTime);
                OnDemandDatabasePoll latestOnDemandPoll = (OnDemandDatabasePoll)latestDatabasePoll;
                if (latestOnDemandPoll.initiationTimeNanos <= checkStartTimeNanos) break block8;
                lock.unlock();
                return;
            }
        }
        OnDemandDatabasePoll onDemandDatabasePoll = new OnDemandDatabasePoll();
        this.latestDatabasePoll = onDemandDatabasePoll;
        this.doOnDemandPoll(onDemandDatabasePoll);
    }

    private void doOnDemandPoll(OnDemandDatabasePoll onDemandPoll) {
        try {
            this.poll();
            onDemandPoll.pollCompletionFuture.complete(null);
        }
        catch (Throwable t) {
            onDemandPoll.pollCompletionFuture.completeExceptionally(t);
            throw t;
        }
    }

    @Override
    public DataSourcesSnapshot getRecentDataSourcesSnapshot() {
        this.useLatestIfWithinDelayOrPerformNewDatabasePoll();
        return this.dataSourcesSnapshot;
    }

    @Override
    public DataSourcesSnapshot forceUpdateDataSourcesSnapshot() {
        this.forceOrWaitOngoingDatabasePoll();
        return this.dataSourcesSnapshot;
    }

    @VisibleForTesting
    DataSourcesSnapshot getLatestDataSourcesSnapshot() {
        return this.dataSourcesSnapshot;
    }

    @VisibleForTesting
    DatabasePoll getLatestDatabasePoll() {
        return this.latestDatabasePoll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void poll() {
        Object object = this.pollLock;
        synchronized (object) {
            if (this.centralizedDatasourceSchemaConfig.isEnabled()) {
                this.pollSegmentAndSchema();
            } else {
                this.pollSegments();
            }
        }
    }

    private void pollSegments() {
        DateTime startTime = DateTimes.nowUtc();
        Stopwatch stopwatch = Stopwatch.createStarted();
        List segments = (List)this.connector.inReadOnlyTransaction((handle, status) -> handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE used=true", (Object[])new Object[]{this.getSegmentsTable()})).setFetchSize(this.connector.getStreamingFetchSize()).map((index, r, ctx) -> {
            try {
                DataSegment segment = (DataSegment)this.segmentReader.readValue(r.getBytes("payload"));
                return this.replaceWithExistingSegmentIfPresent(segment);
            }
            catch (IOException e) {
                log.makeAlert((Throwable)e, "Failed to read segment from db.", new Object[0]).emit();
                return null;
            }
        }).list());
        Preconditions.checkNotNull((Object)segments, (Object)"Unexpected 'null' when polling segments from the db, aborting snapshot update.");
        stopwatch.stop();
        this.emitMetric("segment/poll/time", stopwatch.millisElapsed());
        log.info("Polled and found [%,d] segments in the database in [%,d]ms.", new Object[]{segments.size(), stopwatch.millisElapsed()});
        this.createDatasourcesSnapshot(startTime, segments);
    }

    private void pollSegmentAndSchema() {
        DateTime startTime = DateTimes.nowUtc();
        Stopwatch stopwatch = Stopwatch.createStarted();
        final ImmutableMap.Builder segmentMetadataBuilder = new ImmutableMap.Builder();
        this.segmentSchemaCache.getStats().forEach(this::emitMetric);
        List<DataSegment> segments = this.connector.inReadOnlyTransaction(new TransactionCallback<List<DataSegment>>(){

            public List<DataSegment> inTransaction(Handle handle, TransactionStatus status) {
                return handle.createQuery(StringUtils.format((String)"SELECT payload, schema_fingerprint, num_rows FROM %s WHERE used=true", (Object[])new Object[]{SqlSegmentsMetadataManager.this.getSegmentsTable()})).setFetchSize(SqlSegmentsMetadataManager.this.connector.getStreamingFetchSize()).map((index, r, ctx) -> {
                    try {
                        DataSegment segment = (DataSegment)SqlSegmentsMetadataManager.this.jsonMapper.readValue(r.getBytes("payload"), DataSegment.class);
                        Long numRows = (Long)r.getObject("num_rows");
                        String schemaFingerprint = r.getString("schema_fingerprint");
                        if (schemaFingerprint != null && numRows != null) {
                            segmentMetadataBuilder.put((Object)segment.getId(), (Object)new SegmentMetadata(numRows, schemaFingerprint));
                        }
                        return SqlSegmentsMetadataManager.this.replaceWithExistingSegmentIfPresent(segment);
                    }
                    catch (IOException e) {
                        log.makeAlert((Throwable)e, "Failed to read segment from db.", new Object[0]).emit();
                        return null;
                    }
                }).list();
            }
        });
        ImmutableMap.Builder schemaMapBuilder = new ImmutableMap.Builder();
        String schemaPollQuery = StringUtils.format((String)"SELECT fingerprint, payload FROM %s WHERE version = %s", (Object[])new Object[]{this.getSegmentSchemaTable(), 1});
        this.connector.inReadOnlyTransaction((handle, status) -> {
            handle.createQuery(schemaPollQuery).setFetchSize(this.connector.getStreamingFetchSize()).map((index, r, ctx) -> {
                try {
                    schemaMapBuilder.put((Object)r.getString("fingerprint"), (Object)((SchemaPayload)this.jsonMapper.readValue(r.getBytes("payload"), SchemaPayload.class)));
                }
                catch (IOException e) {
                    log.makeAlert((Throwable)e, "Failed to read schema from db.", new Object[0]).emit();
                }
                return null;
            }).list();
            return null;
        });
        ImmutableMap schemaMap = schemaMapBuilder.build();
        this.segmentSchemaCache.resetSchemaForPublishedSegments((Map<SegmentId, SegmentMetadata>)segmentMetadataBuilder.build(), (Map<String, SchemaPayload>)schemaMap);
        Preconditions.checkNotNull(segments, (Object)"Unexpected 'null' when polling segments from the db, aborting snapshot update.");
        stopwatch.stop();
        this.emitMetric("segment/pollWithSchema/time", stopwatch.millisElapsed());
        log.info("Polled and found [%,d] segments and [%,d] schemas in the database in [%,d]ms.", new Object[]{segments.size(), schemaMap.size(), stopwatch.millisElapsed()});
        this.createDatasourcesSnapshot(startTime, segments);
    }

    private void emitMetric(String metricName, long value) {
        this.serviceEmitter.emit((ServiceEventBuilder)new ServiceMetricEvent.Builder().setMetric(metricName, (Number)value));
    }

    private void createDatasourcesSnapshot(DateTime snapshotTime, List<DataSegment> segments) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.dataSourcesSnapshot = DataSourcesSnapshot.fromUsedSegments(Iterables.filter(segments, Objects::nonNull), snapshotTime);
        this.emitMetric("segment/buildSnapshot/time", stopwatch.millisElapsed());
        log.debug("Created snapshot from polled segments in [%d]ms. Found [%d] overshadowed segments.", new Object[]{stopwatch.millisElapsed(), this.dataSourcesSnapshot.getOvershadowedSegments().size()});
    }

    private DataSegment replaceWithExistingSegmentIfPresent(DataSegment segment) {
        @MonotonicNonNull DataSourcesSnapshot dataSourcesSnapshot = this.dataSourcesSnapshot;
        if (dataSourcesSnapshot == null) {
            return segment;
        }
        ImmutableDruidDataSource dataSource = dataSourcesSnapshot.getDataSource(segment.getDataSource());
        if (dataSource == null) {
            return segment;
        }
        DataSegment alreadyExistingSegment = dataSource.getSegment(segment.getId());
        return alreadyExistingSegment != null ? alreadyExistingSegment : segment;
    }

    private String getSegmentsTable() {
        return ((MetadataStorageTablesConfig)this.dbTables.get()).getSegmentsTable();
    }

    private String getSegmentSchemaTable() {
        return ((MetadataStorageTablesConfig)this.dbTables.get()).getSegmentSchemasTable();
    }

    private static interface DatabasePoll {
    }

    @VisibleForTesting
    static class PeriodicDatabasePoll
    implements DatabasePoll {
        final CompletableFuture<Void> firstPollCompletionFuture = new CompletableFuture();
        long lastPollStartTimestampInMs = -1L;

        PeriodicDatabasePoll() {
        }
    }

    @VisibleForTesting
    static class OnDemandDatabasePoll
    implements DatabasePoll {
        final long initiationTimeNanos = System.nanoTime();
        final CompletableFuture<Void> pollCompletionFuture = new CompletableFuture();

        OnDemandDatabasePoll() {
        }

        long nanosElapsedFromInitiation() {
            return System.nanoTime() - this.initiationTimeNanos;
        }
    }
}

