/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.utils.CollectionUtils;

public class DruidCluster {
    public static final DruidCluster EMPTY = DruidCluster.builder().build();
    private final Set<ServerHolder> realtimes;
    private final Map<String, NavigableSet<ServerHolder>> historicals;
    private final Map<String, NavigableSet<ServerHolder>> managedHistoricals;
    private final Set<ServerHolder> brokers;
    private final List<ServerHolder> allManagedServers;

    private DruidCluster(Set<ServerHolder> realtimes, Map<String, Set<ServerHolder>> historicals, Set<ServerHolder> brokers) {
        this.realtimes = Collections.unmodifiableSet(realtimes);
        this.historicals = CollectionUtils.mapValues(historicals, holders -> CollectionUtils.newTreeSet(Comparator.naturalOrder(), (Iterable)holders));
        this.managedHistoricals = CollectionUtils.mapValues(historicals, holders -> {
            List managedServers = holders.stream().filter(serverHolder -> !serverHolder.isUnmanaged()).collect(Collectors.toList());
            return CollectionUtils.newTreeSet(Comparator.naturalOrder(), managedServers);
        });
        this.brokers = Collections.unmodifiableSet(brokers);
        this.allManagedServers = this.initAllManagedServers();
    }

    public Set<ServerHolder> getRealtimes() {
        return this.realtimes;
    }

    public Map<String, NavigableSet<ServerHolder>> getHistoricals() {
        return this.historicals;
    }

    public Map<String, NavigableSet<ServerHolder>> getManagedHistoricals() {
        return this.managedHistoricals;
    }

    public Set<ServerHolder> getBrokers() {
        return this.brokers;
    }

    public Iterable<String> getTierNames() {
        return this.historicals.keySet();
    }

    public NavigableSet<ServerHolder> getManagedHistoricalsByTier(String tier) {
        return this.managedHistoricals.get(tier);
    }

    public List<ServerHolder> getAllManagedServers() {
        return this.allManagedServers;
    }

    private List<ServerHolder> initAllManagedServers() {
        int historicalSize = this.managedHistoricals.values().stream().mapToInt(Collection::size).sum();
        int realtimeSize = this.realtimes.size();
        ArrayList<ServerHolder> allManagedServers = new ArrayList<ServerHolder>(historicalSize + realtimeSize);
        this.managedHistoricals.values().forEach(allManagedServers::addAll);
        allManagedServers.addAll(this.brokers);
        allManagedServers.addAll(this.realtimes);
        return allManagedServers;
    }

    public boolean isEmpty() {
        return this.historicals.isEmpty() && this.realtimes.isEmpty() && this.brokers.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<ServerHolder> realtimes = new HashSet<ServerHolder>();
        private final Map<String, Set<ServerHolder>> historicals = new HashMap<String, Set<ServerHolder>>();
        private final Set<ServerHolder> brokers = new HashSet<ServerHolder>();

        public Builder add(ServerHolder serverHolder) {
            switch (serverHolder.getServer().getType()) {
                case BRIDGE: 
                case HISTORICAL: {
                    this.addHistorical(serverHolder);
                    break;
                }
                case REALTIME: 
                case INDEXER_EXECUTOR: {
                    this.realtimes.add(serverHolder);
                    break;
                }
                case BROKER: {
                    this.brokers.add(serverHolder);
                    break;
                }
                default: {
                    throw new IAE("unknown server type[%s]", new Object[]{serverHolder.getServer().getType()});
                }
            }
            return this;
        }

        public Builder addRealtimes(ServerHolder ... realtimeServers) {
            this.realtimes.addAll(Arrays.asList(realtimeServers));
            return this;
        }

        public Builder addBrokers(ServerHolder ... brokers) {
            this.brokers.addAll(Arrays.asList(brokers));
            return this;
        }

        public Builder addTier(String tier, ServerHolder ... historicals) {
            this.historicals.computeIfAbsent(tier, t -> new HashSet()).addAll(Arrays.asList(historicals));
            return this;
        }

        private void addHistorical(ServerHolder serverHolder) {
            String tier = serverHolder.getServer().getTier();
            this.historicals.computeIfAbsent(tier, t -> new HashSet()).add(serverHolder);
        }

        public DruidCluster build() {
            return new DruidCluster(this.realtimes, this.historicals, this.brokers);
        }
    }
}

