/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import io.fabric8.kubernetes.api.model.Pod;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PeonPhase {
    PENDING("Pending"),
    SUCCEEDED("Succeeded"),
    FAILED("Failed"),
    UNKNOWN("Unknown"),
    RUNNING("Running");

    private static final Map<String, PeonPhase> PHASE_MAP;
    private final String phase;

    private PeonPhase(String phase) {
        this.phase = phase;
    }

    public String getPhase() {
        return this.phase;
    }

    public static PeonPhase getPhaseFor(Pod pod) {
        if (pod == null) {
            return UNKNOWN;
        }
        return PHASE_MAP.get(pod.getStatus().getPhase());
    }

    static {
        PHASE_MAP = Arrays.stream(PeonPhase.values()).collect(Collectors.toMap(PeonPhase::getPhase, Function.identity()));
    }
}

