/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure.output;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.StorageConnectorProvider;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.output.AzureOutputConfig;
import org.apache.druid.storage.azure.output.AzureStorageConnector;

@JsonTypeName(value="azure")
public class AzureStorageConnectorProvider
extends AzureOutputConfig
implements StorageConnectorProvider {
    @Global
    @JacksonInject
    AzureStorage azureStorage;

    @JsonCreator
    public AzureStorageConnectorProvider(@JsonProperty(value="container", required=true) String container, @JsonProperty(value="prefix", required=true) String prefix, @JsonProperty(value="tempDir") @Nullable File tempDir, @JsonProperty(value="chunkSize") @Nullable HumanReadableBytes chunkSize, @JsonProperty(value="maxRetry") @Nullable Integer maxRetry) {
        super(container, prefix, tempDir, chunkSize, maxRetry);
    }

    public StorageConnector createStorageConnector(File defaultTempDir) {
        AzureStorageConnectorProvider config = this.getTempDir() == null ? this.withTempDir(defaultTempDir) : this;
        config.validateTempDirectory();
        return new AzureStorageConnector(config, this.azureStorage);
    }
}

