/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;

public class Utils {
    private static final Logger log = new Logger(Utils.class);
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    public static OutputStream makePathAndOutputStream(JobContext job, Path outputPath, boolean deleteExisting) throws IOException {
        FileSystem fs = outputPath.getFileSystem(job.getConfiguration());
        CompressionCodec codec = null;
        if (FileOutputFormat.getCompressOutput((JobContext)job)) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)job.getConfiguration());
            outputPath = new Path(String.valueOf(outputPath) + codec.getDefaultExtension());
        }
        if (fs.exists(outputPath)) {
            if (deleteExisting) {
                fs.delete(outputPath, false);
            } else {
                throw new ISE("outputPath[%s] must not exist.", new Object[]{outputPath});
            }
        }
        Object retVal = FileOutputFormat.getCompressOutput((JobContext)job) ? codec.createOutputStream((OutputStream)fs.create(outputPath, false)) : fs.create(outputPath, false);
        return retVal;
    }

    public static InputStream openInputStream(JobContext job, Path inputPath) throws IOException {
        return Utils.openInputStream(job, inputPath, inputPath.getFileSystem(job.getConfiguration()));
    }

    public static boolean exists(JobContext job, FileSystem fs, Path inputPath) throws IOException {
        if (!FileOutputFormat.getCompressOutput((JobContext)job)) {
            return fs.exists(inputPath);
        }
        Class codecClass = FileOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)job.getConfiguration());
        return fs.exists(new Path(String.valueOf(inputPath) + codec.getDefaultExtension()));
    }

    public static InputStream openInputStream(JobContext job, Path inputPath, FileSystem fileSystem) throws IOException {
        if (!FileOutputFormat.getCompressOutput((JobContext)job)) {
            return fileSystem.open(inputPath);
        }
        Class codecClass = FileOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)job.getConfiguration());
        inputPath = new Path(String.valueOf(inputPath) + codec.getDefaultExtension());
        return codec.createInputStream((InputStream)fileSystem.open(inputPath));
    }

    public static Map<String, Object> getStats(JobContext job, Path statsPath) throws IOException {
        FileSystem fs = statsPath.getFileSystem(job.getConfiguration());
        return (Map)JSON_MAPPER.readValue((InputStream)fs.open(statsPath), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
    }

    public static void storeStats(JobContext job, Path path, Map<String, Object> stats) throws IOException {
        JSON_MAPPER.writeValue(Utils.makePathAndOutputStream(job, path, true), stats);
    }

    @Nullable
    public static String getFailureMessage(Job failedJob, ObjectMapper jsonMapper) {
        try {
            TaskCompletionEvent[] completionEvents;
            HashMap<String, String> taskDiagsMap = new HashMap<String, String>();
            for (TaskCompletionEvent tce : completionEvents = failedJob.getTaskCompletionEvents(0, 100)) {
                String[] taskDiags = failedJob.getTaskDiagnostics(tce.getTaskAttemptId());
                StringBuilder combinedTaskDiags = new StringBuilder();
                for (String taskDiag : taskDiags) {
                    combinedTaskDiags.append(taskDiag);
                }
                taskDiagsMap.put(tce.getTaskAttemptId().toString(), combinedTaskDiags.toString());
            }
            return jsonMapper.writeValueAsString(taskDiagsMap);
        }
        catch (IOException | InterruptedException ie) {
            log.error((Throwable)ie, "couldn't get failure cause for job [%s]", new Object[]{failedJob.getJobName()});
            return null;
        }
    }

    public static boolean checkAppSuccessForJobIOException(IOException ioe, Job job, boolean useYarnRMJobStatusFallback) {
        if (!useYarnRMJobStatusFallback) {
            log.info("useYarnRMJobStatusFallback is false, not checking YARN ResourceManager.", new Object[0]);
            return false;
        }
        log.error((Throwable)ioe, "Encountered IOException with job, checking application success from YARN ResourceManager.", new Object[0]);
        boolean success = Utils.checkAppSuccessFromYarnRM(job);
        if (!success) {
            log.error("YARN RM did not report job success either.", new Object[0]);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAppSuccessFromYarnRM(Job job) {
        HttpClient httpClient = new HttpClient();
        AtomicBoolean succeeded = new AtomicBoolean(false);
        try {
            httpClient.start();
            RetryUtils.retry(() -> {
                Utils.checkAppSuccessFromYarnRMOnce(httpClient, job, succeeded);
                return null;
            }, ex -> !succeeded.get(), (int)5);
            boolean bl = succeeded.get();
            return bl;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Got exception while trying to contact YARN RM.", new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                httpClient.stop();
            }
            catch (Exception e) {
                log.error((Throwable)e, "Got exception with httpClient.stop() while trying to contact YARN RM.", new Object[0]);
            }
        }
    }

    private static void checkAppSuccessFromYarnRMOnce(HttpClient httpClient, Job job, AtomicBoolean succeeded) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        String appId = StringUtils.replace((String)job.getJobID().toString(), (String)"job", (String)"application");
        String yarnRM = job.getConfiguration().get("yarn.resourcemanager.webapp.address");
        String yarnEndpoint = StringUtils.format((String)"http://%s/ws/v1/cluster/apps/%s", (Object[])new Object[]{yarnRM, appId});
        log.info("Attempting to retrieve app status from YARN ResourceManager at [%s].", new Object[]{yarnEndpoint});
        ContentResponse res = httpClient.GET(yarnEndpoint);
        log.info("App status response from YARN RM: " + res.getContentAsString(), new Object[0]);
        Map respMap = (Map)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(res.getContentAsString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map appMap = (Map)respMap.get("app");
        String state = (String)appMap.get("state");
        String finalStatus = (String)appMap.get("finalStatus");
        if ("FINISHED".equals(state) && "SUCCEEDED".equals(finalStatus)) {
            succeeded.set(true);
        }
    }
}

