/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import com.google.inject.Inject;
import org.apache.druid.messages.client.MessageListener;
import org.apache.druid.msq.dart.controller.ControllerHolder;
import org.apache.druid.msq.dart.controller.DartControllerRegistry;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.dart.worker.WorkerId;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.server.DruidNode;

public class ControllerMessageListener
implements MessageListener<ControllerMessage> {
    private final DartControllerRegistry controllerRegistry;

    @Inject
    public ControllerMessageListener(DartControllerRegistry controllerRegistry) {
        this.controllerRegistry = controllerRegistry;
    }

    public void messageReceived(ControllerMessage message) {
        ControllerHolder holder = this.controllerRegistry.get(message.getQueryId());
        if (holder != null) {
            message.handle(holder.getController());
        }
    }

    public void serverAdded(DruidNode node) {
    }

    public void serverRemoved(DruidNode node) {
        for (ControllerHolder holder : this.controllerRegistry.getAllHolders()) {
            Controller controller = holder.getController();
            WorkerId workerId = WorkerId.fromDruidNode(node, controller.queryId());
            holder.workerOffline(workerId);
        }
    }
}

