/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.msq.dart.controller.DartTableInputSpecSlicer;
import org.apache.druid.msq.dart.controller.DartWorkerManager;
import org.apache.druid.msq.dart.worker.DartWorkerClient;
import org.apache.druid.msq.dart.worker.WorkerId;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.exec.ControllerContext;
import org.apache.druid.msq.exec.ControllerMemoryParameters;
import org.apache.druid.msq.exec.MSQMetriceEventBuilder;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.exec.SegmentSource;
import org.apache.druid.msq.exec.WorkerManager;
import org.apache.druid.msq.indexing.IndexerControllerContext;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.destination.TaskReportMSQDestination;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.kernel.controller.ControllerQueryKernelConfig;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;

public class DartControllerContext
implements ControllerContext {
    public static final int DEFAULT_MAX_CONCURRENT_STAGES = 2;
    public static final int DEFAULT_TARGET_PARTITIONS_PER_WORKER = 1;
    public static final String CTX_MAX_NON_LEAF_WORKER_COUNT = "maxNonLeafWorkers";
    public static final int DEFAULT_MAX_NON_LEAF_WORKER_COUNT = 1;
    public static final SegmentSource DEFAULT_SEGMENT_SOURCE = SegmentSource.REALTIME;
    private final Injector injector;
    private final ObjectMapper jsonMapper;
    private final DruidNode selfNode;
    private final DartWorkerClient workerClient;
    private final TimelineServerView serverView;
    private final MemoryIntrospector memoryIntrospector;
    private final QueryContext context;
    private final ServiceEmitter emitter;

    public DartControllerContext(Injector injector, ObjectMapper jsonMapper, DruidNode selfNode, DartWorkerClient workerClient, MemoryIntrospector memoryIntrospector, TimelineServerView serverView, ServiceEmitter emitter, QueryContext context) {
        this.injector = injector;
        this.jsonMapper = jsonMapper;
        this.selfNode = selfNode;
        this.workerClient = workerClient;
        this.serverView = serverView;
        this.memoryIntrospector = memoryIntrospector;
        this.context = context;
        this.emitter = emitter;
    }

    @Override
    public String queryId() {
        return this.context.getString("dartQueryId");
    }

    @Override
    public ControllerQueryKernelConfig queryKernelConfig(MSQSpec querySpec) {
        List servers = this.serverView.getDruidServerMetadatas();
        ArrayList<String> workerIds = new ArrayList<String>(servers.size());
        for (DruidServerMetadata server : servers) {
            if (server.getType() != ServerType.HISTORICAL) continue;
            workerIds.add(WorkerId.fromDruidServerMetadata(server, this.queryId()).toString());
        }
        Collections.shuffle(workerIds);
        ControllerMemoryParameters memoryParameters = ControllerMemoryParameters.createProductionInstance(this.memoryIntrospector, workerIds.size());
        int maxConcurrentStages = MultiStageQueryContext.getMaxConcurrentStagesWithDefault(querySpec.getContext(), 2);
        return ControllerQueryKernelConfig.builder().controllerHost(this.selfNode.getHostAndPortToUse()).workerIds(workerIds).pipeline(maxConcurrentStages > 1).destination(TaskReportMSQDestination.instance()).maxConcurrentStages(maxConcurrentStages).maxRetainedPartitionSketchBytes(memoryParameters.getPartitionStatisticsMaxRetainedBytes()).workerContextMap(IndexerControllerContext.makeWorkerContextMap(querySpec, false, maxConcurrentStages)).build();
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public void emitMetric(MSQMetriceEventBuilder metricBuilder) {
        metricBuilder.setDartDimensions(this.context);
        metricBuilder.setDimension("dartQueryId", this.context.get("dartQueryId"));
        this.emitter.emit((ServiceEventBuilder)metricBuilder);
    }

    @Override
    public DruidNode selfNode() {
        return this.selfNode;
    }

    @Override
    public InputSpecSlicer newTableInputSpecSlicer(WorkerManager workerManager) {
        return DartTableInputSpecSlicer.createFromWorkerIds(workerManager.getWorkerIds(), this.serverView, this.context);
    }

    @Override
    public TaskActionClient taskActionClient() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WorkerManager newWorkerManager(String queryId, MSQSpec querySpec, ControllerQueryKernelConfig queryKernelConfig) {
        return new DartWorkerManager(queryKernelConfig.getWorkerIds(), this.workerClient);
    }

    @Override
    public DartWorkerClient newWorkerClient() {
        return this.workerClient;
    }

    @Override
    public void registerController(Controller controller, Closer closer) {
        closer.register((Closeable)this.workerClient);
    }

    @Override
    public TaskLockType taskLockType() {
        throw DruidException.defensive((String)"TaskLockType is not used with class[%s]", (Object[])new Object[]{this.getClass().getName()});
    }
}

