/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Injector;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.msq.dart.controller.DartControllerContext;
import org.apache.druid.msq.dart.controller.DartControllerContextFactory;
import org.apache.druid.msq.dart.worker.DartWorkerClientImpl;
import org.apache.druid.msq.exec.ControllerContext;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.query.QueryContext;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.server.DruidNode;

public class DartControllerContextFactoryImpl
implements DartControllerContextFactory {
    protected final Injector injector;
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    protected final DruidNode selfNode;
    protected final ServiceClientFactory serviceClientFactory;
    protected final TimelineServerView serverView;
    protected final MemoryIntrospector memoryIntrospector;
    protected final ServiceEmitter emitter;

    @Inject
    public DartControllerContextFactoryImpl(Injector injector, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, @Self DruidNode selfNode, @EscalatedGlobal ServiceClientFactory serviceClientFactory, MemoryIntrospector memoryIntrospector, TimelineServerView serverView, ServiceEmitter emitter) {
        this.injector = injector;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.selfNode = selfNode;
        this.serviceClientFactory = serviceClientFactory;
        this.serverView = serverView;
        this.memoryIntrospector = memoryIntrospector;
        this.emitter = emitter;
    }

    @Override
    public ControllerContext newContext(QueryContext context) {
        String queryId = context.getString("dartQueryId");
        return new DartControllerContext(this.injector, this.jsonMapper, this.selfNode, new DartWorkerClientImpl(queryId, this.serviceClientFactory, this.smileMapper, this.selfNode.getHostAndPortToUse()), this.memoryIntrospector, this.serverView, this.emitter, context);
    }
}

