/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import com.google.common.collect.FluentIterable;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.msq.dart.controller.DartControllerContext;
import org.apache.druid.msq.dart.controller.DartSegmentAssignment;
import org.apache.druid.msq.dart.worker.DartQueryableSegment;
import org.apache.druid.msq.dart.worker.WorkerId;
import org.apache.druid.msq.exec.SegmentSource;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.input.table.DataServerRequestDescriptor;
import org.apache.druid.msq.input.table.DataServerSelector;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.input.table.TableInputSpec;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.CloneQueryMode;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilterUtils;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineLookup;
import org.joda.time.Interval;

public class DartTableInputSpecSlicer
implements InputSpecSlicer {
    private static final int UNKNOWN = -1;
    private final Object2IntMap<String> workerIdToNumber;
    private final TimelineServerView serverView;
    private final SegmentSource segmentSource;
    private final CloneQueryMode cloneQueryMode;

    DartTableInputSpecSlicer(Object2IntMap<String> workerIdToNumber, TimelineServerView serverView, QueryContext queryContext) {
        this.workerIdToNumber = workerIdToNumber;
        this.serverView = serverView;
        this.segmentSource = MultiStageQueryContext.getSegmentSources(queryContext, DartControllerContext.DEFAULT_SEGMENT_SOURCE);
        this.cloneQueryMode = queryContext.getCloneQueryMode();
    }

    public static DartTableInputSpecSlicer createFromWorkerIds(List<String> workerIds, TimelineServerView serverView, QueryContext queryContext) {
        Object2IntOpenHashMap reverseWorkers = new Object2IntOpenHashMap();
        reverseWorkers.defaultReturnValue(-1);
        for (int i = 0; i < workerIds.size(); ++i) {
            reverseWorkers.put((Object)WorkerId.fromString(workerIds.get(i)).getHostAndPort(), i);
        }
        return new DartTableInputSpecSlicer((Object2IntMap<String>)reverseWorkers, serverView, queryContext);
    }

    @Override
    public boolean canSliceDynamic(InputSpec inputSpec) {
        return false;
    }

    @Override
    public List<InputSlice> sliceStatic(InputSpec inputSpec, int maxNumSlices) {
        int worker;
        TableInputSpec tableInputSpec = (TableInputSpec)inputSpec;
        TimelineLookup timeline = this.serverView.getTimeline(new TableDataSource(tableInputSpec.getDataSource())).orElse(null);
        if (timeline == null) {
            return Collections.emptyList();
        }
        Set<DartQueryableSegment> prunedSegments = this.findQueryableDataSegments(tableInputSpec, timeline, serverSelector -> this.findWorkerForServerSelector((ServerSelector)serverSelector, maxNumSlices));
        ArrayList<DartSegmentAssignment> assignments = new ArrayList<DartSegmentAssignment>(maxNumSlices);
        while (assignments.size() < maxNumSlices) {
            assignments.add(DartSegmentAssignment.empty());
        }
        int nextRoundRobinWorker = 0;
        HashMap<DruidServerMetadata, List> serverRequestMap = new HashMap<DruidServerMetadata, List>();
        for (DartQueryableSegment dartQueryableSegment : prunedSegments) {
            DruidServerMetadata realtimeServer = dartQueryableSegment.getRealtimeServer();
            if (realtimeServer != null) {
                serverRequestMap.computeIfAbsent(realtimeServer, s -> new ArrayList()).add(dartQueryableSegment);
                continue;
            }
            if (dartQueryableSegment.getWorkerNumber() == -1) {
                worker = nextRoundRobinWorker;
                nextRoundRobinWorker = (nextRoundRobinWorker + 1) % maxNumSlices;
            } else {
                worker = dartQueryableSegment.getWorkerNumber();
            }
            ((DartSegmentAssignment)assignments.get(worker)).addSegments(dartQueryableSegment);
        }
        for (Map.Entry entry : serverRequestMap.entrySet()) {
            DruidServerMetadata server = (DruidServerMetadata)entry.getKey();
            worker = nextRoundRobinWorker;
            nextRoundRobinWorker = (nextRoundRobinWorker + 1) % maxNumSlices;
            List<RichSegmentDescriptor> descriptors = ((List)serverRequestMap.get(server)).stream().map(DartTableInputSpecSlicer::toRichSegmentDescriptor).collect(Collectors.toList());
            ((DartSegmentAssignment)assignments.get(worker)).addRequest(new DataServerRequestDescriptor(server, descriptors));
        }
        return this.makeSegmentSlices(tableInputSpec.getDataSource(), assignments);
    }

    @Override
    public List<InputSlice> sliceDynamic(InputSpec inputSpec, int maxNumSlices, int maxFilesPerSlice, long maxBytesPerSlice) {
        throw new UnsupportedOperationException();
    }

    int findWorkerForServerSelector(ServerSelector serverSelector, int maxNumSlices) {
        QueryableDruidServer server = serverSelector.pick(null, this.cloneQueryMode);
        if (server == null) {
            return -1;
        }
        String serverHostAndPort = server.getServer().getHost();
        int workerNumber = this.workerIdToNumber.getInt((Object)serverHostAndPort);
        if (workerNumber != -1 && workerNumber < maxNumSlices) {
            return workerNumber;
        }
        return -1;
    }

    private Set<DartQueryableSegment> findQueryableDataSegments(TableInputSpec tableInputSpec, TimelineLookup<?, ServerSelector> timeline, ToIntFunction<ServerSelector> toWorkersFunction) {
        FluentIterable allSegments = FluentIterable.from((Iterable)JodaUtils.condenseIntervals(tableInputSpec.getIntervals())).transformAndConcat(arg_0 -> timeline.lookup(arg_0)).transformAndConcat(holder -> FluentIterable.from((Iterable)holder.getObject()).filter(chunk -> this.shouldIncludeSegment((ServerSelector)chunk.getObject())).transform(chunk -> {
            ServerSelector serverSelector = (ServerSelector)chunk.getObject();
            return this.toDartQueryableSegment(serverSelector, holder.getInterval(), toWorkersFunction);
        }).filter(segment -> !segment.getSegment().isTombstone()));
        return DimFilterUtils.filterShards((DimFilter)tableInputSpec.getFilter(), tableInputSpec.getFilterFields(), (Iterable)allSegments, segment -> segment.getSegment().getShardSpec(), new HashMap());
    }

    private DartQueryableSegment toDartQueryableSegment(ServerSelector serverSelector, Interval interval, ToIntFunction<ServerSelector> toWorkersFunction) {
        DataSegment dataSegment = serverSelector.getSegment();
        if (serverSelector.isRealtimeSegment()) {
            Set servers = serverSelector.getAllServers(this.cloneQueryMode).stream().filter(druidServerMetadata -> this.segmentSource.getUsedServerTypes().contains(druidServerMetadata.getType())).collect(Collectors.toSet());
            return new DartQueryableSegment(dataSegment, interval, -1, DataServerSelector.RANDOM.getSelectServerFunction().apply(servers));
        }
        int worker = toWorkersFunction.applyAsInt(serverSelector);
        return new DartQueryableSegment(dataSegment, interval, worker, null);
    }

    private List<InputSlice> makeSegmentSlices(String dataSource, List<DartSegmentAssignment> assignments) {
        ArrayList<InputSlice> retVal = new ArrayList<InputSlice>(assignments.size());
        for (DartSegmentAssignment assignment : assignments) {
            if (assignment == null || assignment.isEmpty()) {
                retVal.add(NilInputSlice.INSTANCE);
                continue;
            }
            ArrayList<RichSegmentDescriptor> descriptors = new ArrayList<RichSegmentDescriptor>();
            for (DartQueryableSegment segment : assignment.getDartQueryableSegments()) {
                if (!dataSource.equals(segment.getSegment().getDataSource())) {
                    throw new ISE("Expected dataSource[%s] but got[%s]", new Object[]{dataSource, segment.getSegment().getDataSource()});
                }
                descriptors.add(DartTableInputSpecSlicer.toRichSegmentDescriptor(segment));
            }
            List<DataServerRequestDescriptor> queryableDruidServers = assignment.getDataServerRequestDescriptor();
            retVal.add(new SegmentsInputSlice(dataSource, descriptors, queryableDruidServers));
        }
        return retVal;
    }

    static RichSegmentDescriptor toRichSegmentDescriptor(DartQueryableSegment segment) {
        return new RichSegmentDescriptor(segment.getSegment().getInterval(), segment.getInterval(), segment.getSegment().getVersion(), segment.getSegment().getShardSpec().getPartitionNum());
    }

    private boolean shouldIncludeSegment(ServerSelector serverSelector) {
        if (serverSelector.getSegment().isTombstone()) {
            return false;
        }
        if (serverSelector.isRealtimeSegment()) {
            return SegmentSource.shouldQueryRealtimeServers(this.segmentSource);
        }
        return true;
    }
}

