/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.error.DruidException;
import org.apache.druid.msq.exec.DataServerQueryHandlerFactory;
import org.apache.druid.msq.exec.FrameContext;
import org.apache.druid.msq.exec.FrameWriterSpec;
import org.apache.druid.msq.exec.ProcessingBuffers;
import org.apache.druid.msq.exec.WorkerContext;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.exec.WorkerStorageParameters;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.incremental.NoopRowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.loading.DataSegmentPusher;

public class DartFrameContext
implements FrameContext {
    private final StageId stageId;
    private final FrameWriterSpec frameWriterSpec;
    private final SegmentWrangler segmentWrangler;
    private final GroupingEngine groupingEngine;
    private final DataSegmentProvider dataSegmentProvider;
    private final WorkerContext workerContext;
    private final ResourceHolder<ProcessingBuffers> processingBuffers;
    private final WorkerMemoryParameters memoryParameters;
    private final WorkerStorageParameters storageParameters;
    private final DataServerQueryHandlerFactory dataServerQueryHandlerFactory;

    public DartFrameContext(StageId stageId, WorkerContext workerContext, FrameWriterSpec frameWriterSpec, SegmentWrangler segmentWrangler, GroupingEngine groupingEngine, DataSegmentProvider dataSegmentProvider, ResourceHolder<ProcessingBuffers> processingBuffers, WorkerMemoryParameters memoryParameters, WorkerStorageParameters storageParameters, DataServerQueryHandlerFactory dataServerQueryHandlerFactory) {
        this.stageId = stageId;
        this.segmentWrangler = segmentWrangler;
        this.frameWriterSpec = frameWriterSpec;
        this.groupingEngine = groupingEngine;
        this.dataSegmentProvider = dataSegmentProvider;
        this.workerContext = workerContext;
        this.processingBuffers = processingBuffers;
        this.memoryParameters = memoryParameters;
        this.storageParameters = storageParameters;
        this.dataServerQueryHandlerFactory = dataServerQueryHandlerFactory;
    }

    @Override
    public PolicyEnforcer policyEnforcer() {
        return this.workerContext.policyEnforcer();
    }

    @Override
    public SegmentWrangler segmentWrangler() {
        return this.segmentWrangler;
    }

    @Override
    public GroupingEngine groupingEngine() {
        return this.groupingEngine;
    }

    @Override
    public RowIngestionMeters rowIngestionMeters() {
        return new NoopRowIngestionMeters();
    }

    @Override
    public DataSegmentProvider dataSegmentProvider() {
        return this.dataSegmentProvider;
    }

    @Override
    public File tempDir() {
        return new File(this.workerContext.tempDir(), this.stageId.toString());
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.workerContext.jsonMapper();
    }

    @Override
    public IndexIO indexIO() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File persistDir() {
        return new File(this.tempDir(), "persist");
    }

    @Override
    public DataSegmentPusher segmentPusher() {
        throw DruidException.defensive((String)"Ingestion not implemented", (Object[])new Object[0]);
    }

    @Override
    public IndexMergerV9 indexMerger() {
        throw DruidException.defensive((String)"Ingestion not implemented", (Object[])new Object[0]);
    }

    @Override
    public ProcessingBuffers processingBuffers() {
        return (ProcessingBuffers)this.processingBuffers.get();
    }

    @Override
    public WorkerMemoryParameters memoryParameters() {
        return this.memoryParameters;
    }

    @Override
    public WorkerStorageParameters storageParameters() {
        return this.storageParameters;
    }

    @Override
    public DataServerQueryHandlerFactory dataServerQueryHandlerFactory() {
        return this.dataServerQueryHandlerFactory;
    }

    @Override
    public FrameWriterSpec frameWriterSpec() {
        return this.frameWriterSpec;
    }

    @Override
    public void close() {
        this.processingBuffers.close();
    }
}

