/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TooManyInputFiles")
public class TooManyInputFilesFault
extends BaseMSQFault {
    static final String CODE = "TooManyInputFiles";
    private final int numInputFiles;
    private final int maxInputFiles;
    private final int minNumWorkers;

    @JsonCreator
    public TooManyInputFilesFault(@JsonProperty(value="numInputFiles") int numInputFiles, @JsonProperty(value="maxInputFiles") int maxInputFiles, @JsonProperty(value="minNumWorkers") int minNumWorkers) {
        super(CODE, "Too many input files/segments [%d] encountered. Maximum input files/segments per worker is set to [%d]. Try breaking your query up into smaller queries, or increasing the number of workers to at least [%d] by setting %s in your query context", numInputFiles, maxInputFiles, minNumWorkers, "maxNumTasks");
        this.numInputFiles = numInputFiles;
        this.maxInputFiles = maxInputFiles;
        this.minNumWorkers = minNumWorkers;
    }

    @JsonProperty
    public int getNumInputFiles() {
        return this.numInputFiles;
    }

    @JsonProperty
    public int getMaxInputFiles() {
        return this.maxInputFiles;
    }

    @JsonProperty
    public int getMinNumWorkers() {
        return this.minNumWorkers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManyInputFilesFault that = (TooManyInputFilesFault)o;
        return this.numInputFiles == that.numInputFiles && this.maxInputFiles == that.maxInputFiles && this.minNumWorkers == that.minNumWorkers;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numInputFiles, this.maxInputFiles, this.minNumWorkers);
    }
}

