/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.stage;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.stage.ReadablePartitions;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.input.stage.StageInputSpec;

public class StageInputSpecSlicer
implements InputSpecSlicer {
    private final Int2ObjectMap<ReadablePartitions> stagePartitionsMap;
    private final Int2ObjectMap<OutputChannelMode> stageOutputChannelModeMap;

    public StageInputSpecSlicer(Int2ObjectMap<ReadablePartitions> stagePartitionsMap, Int2ObjectMap<OutputChannelMode> stageOutputChannelModeMap) {
        this.stagePartitionsMap = stagePartitionsMap;
        this.stageOutputChannelModeMap = stageOutputChannelModeMap;
    }

    @Override
    public boolean canSliceDynamic(InputSpec inputSpec) {
        return false;
    }

    @Override
    public List<InputSlice> sliceStatic(InputSpec inputSpec, int maxNumSlices) {
        StageInputSpec stageInputSpec = (StageInputSpec)inputSpec;
        ReadablePartitions stagePartitions = (ReadablePartitions)this.stagePartitionsMap.get(stageInputSpec.getStageNumber());
        OutputChannelMode outputChannelMode = (OutputChannelMode)((Object)this.stageOutputChannelModeMap.get(stageInputSpec.getStageNumber()));
        if (stagePartitions == null) {
            throw new ISE("Stage[%d] output partitions not available", new Object[]{stageInputSpec.getStageNumber()});
        }
        if (outputChannelMode == null) {
            throw new ISE("Stage[%d] output mode not available", new Object[]{stageInputSpec.getStageNumber()});
        }
        List<ReadablePartitions> workerPartitions = stagePartitions.split(maxNumSlices);
        ArrayList<InputSlice> retVal = new ArrayList<InputSlice>();
        for (ReadablePartitions partitions : workerPartitions) {
            retVal.add(new StageInputSlice(stageInputSpec.getStageNumber(), partitions, outputChannelMode));
        }
        return retVal;
    }

    @Override
    public List<InputSlice> sliceDynamic(InputSpec inputSpec, int maxNumSlices, int maxFilesPerSlice, long maxBytesPerSlice) {
        throw new UnsupportedOperationException("Cannot sliceDynamic.");
    }
}

