/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.druid.msq.exec.StageProcessor;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.segment.column.RowSignature;

public class StageDefinitionBuilder {
    private final int stageNumber;
    private final List<InputSpec> inputSpecs = new ArrayList<InputSpec>();
    private final IntSet broadcastInputNumbers = new IntRBTreeSet();
    private StageProcessor processor;
    private RowSignature signature = RowSignature.empty();
    private int maxWorkerCount = 1;
    private ShuffleSpec shuffleSpec = null;
    private boolean shuffleCheckHasMultipleValues = false;

    StageDefinitionBuilder(int stageNumber) {
        this.stageNumber = stageNumber;
    }

    StageDefinitionBuilder(StageDefinitionBuilder other) {
        this.stageNumber = other.stageNumber;
        this.inputs(other.inputSpecs);
        this.broadcastInputs(other.broadcastInputNumbers);
        this.processor(other.processor);
        this.signature(other.signature);
        this.maxWorkerCount(other.maxWorkerCount);
        this.shuffleSpec(other.shuffleSpec);
        this.shuffleCheckHasMultipleValues(other.shuffleCheckHasMultipleValues);
    }

    public StageDefinitionBuilder inputs(List<InputSpec> inputSpecs) {
        this.inputSpecs.clear();
        this.inputSpecs.addAll(inputSpecs);
        return this;
    }

    public StageDefinitionBuilder inputs(InputSpec ... inputSpecs) {
        return this.inputs(Arrays.asList(inputSpecs));
    }

    public StageDefinitionBuilder broadcastInputs(IntSet broadcastInputNumbers) {
        this.broadcastInputNumbers.clear();
        IntIterator intIterator = broadcastInputNumbers.iterator();
        while (intIterator.hasNext()) {
            int broadcastInputNumber = (Integer)intIterator.next();
            this.broadcastInputNumbers.add(broadcastInputNumber);
        }
        return this;
    }

    public StageDefinitionBuilder processor(StageProcessor processor) {
        this.processor = processor;
        return this;
    }

    public StageDefinitionBuilder signature(RowSignature signature) {
        this.signature = signature;
        return this;
    }

    public StageDefinitionBuilder maxWorkerCount(int maxWorkerCount) {
        this.maxWorkerCount = maxWorkerCount;
        return this;
    }

    public StageDefinitionBuilder shuffleCheckHasMultipleValues(boolean shuffleCheckHasMultipleValues) {
        this.shuffleCheckHasMultipleValues = shuffleCheckHasMultipleValues;
        return this;
    }

    public StageDefinitionBuilder shuffleSpec(ShuffleSpec shuffleSpec) {
        this.shuffleSpec = shuffleSpec;
        return this;
    }

    public int getStageNumber() {
        return this.stageNumber;
    }

    public RowSignature getSignature() {
        return this.signature;
    }

    public StageDefinition build(String queryId) {
        return new StageDefinition(new StageId(queryId, this.stageNumber), this.inputSpecs, (Set<Integer>)this.broadcastInputNumbers, this.processor, this.signature, this.shuffleSpec, this.maxWorkerCount, this.shuffleCheckHasMultipleValues);
    }

    public StageDefinitionBuilder copy() {
        return new StageDefinitionBuilder(this);
    }
}

