/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.logical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.msq.input.inline.InlineInputSpec;
import org.apache.druid.msq.input.table.TableInputSpec;
import org.apache.druid.msq.logical.LogicalInputSpec;
import org.apache.druid.msq.logical.stages.LogicalStage;
import org.apache.druid.msq.logical.stages.OffsetLimitStage;
import org.apache.druid.msq.logical.stages.ReadStage;
import org.apache.druid.msq.logical.stages.SortStage;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.querygen.DruidQueryGenerator;
import org.apache.druid.sql.calcite.planner.querygen.SourceDescProducer;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;
import org.apache.druid.sql.calcite.rel.logical.DruidSort;
import org.apache.druid.sql.calcite.rel.logical.DruidTableScan;
import org.apache.druid.sql.calcite.rel.logical.DruidValues;
import org.joda.time.Interval;

public class DruidLogicalToQueryDefinitionTranslator {
    private PlannerContext plannerContext;

    public DruidLogicalToQueryDefinitionTranslator(PlannerContext plannerContext) {
        this.plannerContext = plannerContext;
    }

    public LogicalStage translate(DruidLogicalNode relRoot) {
        DruidQueryGenerator.DruidNodeStack stack = new DruidQueryGenerator.DruidNodeStack(this.plannerContext);
        stack.push(relRoot);
        LogicalStage logicalStage = this.buildStageFor(stack);
        return logicalStage;
    }

    private LogicalStage buildStageFor(DruidQueryGenerator.DruidNodeStack stack) {
        Optional<ReadStage> stage;
        List<LogicalStage> inputStages = this.buildInputStages(stack);
        DruidLogicalNode node = stack.getNode();
        if (inputStages.size() == 0 && (stage = this.buildReadStage(node)).isPresent()) {
            return stage.get();
        }
        if (inputStages.size() == 1) {
            LogicalStage inputStage = inputStages.get(0);
            LogicalStage newStage = inputStage.extendWith(stack);
            if (newStage != null) {
                return newStage;
            }
            newStage = this.makeSequenceStage(inputStage, stack);
            if (newStage != null) {
                return newStage;
            }
        }
        throw DruidException.defensive().build("Unable to process relNode[%s]", new Object[]{node});
    }

    private Optional<ReadStage> buildReadStage(DruidLogicalNode node) {
        if (node instanceof DruidValues) {
            return this.translateValues((DruidValues)node);
        }
        if (node instanceof DruidTableScan) {
            return this.translateTableScan((DruidTableScan)node);
        }
        return Optional.empty();
    }

    private LogicalStage makeSequenceStage(LogicalStage inputStage, DruidQueryGenerator.DruidNodeStack stack) {
        if (stack.getNode() instanceof DruidSort) {
            DruidSort sort = (DruidSort)stack.getNode();
            List orderBySpecs = DruidQuery.buildOrderByColumnSpecs((RowSignature)inputStage.getLogicalRowSignature(), (Sort)sort);
            List keyColumns = Lists.transform((List)orderBySpecs, KeyColumn::fromOrderByColumnSpec);
            SortStage sortStage = new SortStage(inputStage, keyColumns);
            if (sort.hasLimitOrOffset()) {
                return new OffsetLimitStage(sortStage, sort.getOffsetLimit());
            }
            return sortStage;
        }
        return new ReadStage(inputStage.getLogicalRowSignature(), LogicalInputSpec.of(inputStage)).extendWith(stack);
    }

    private List<LogicalStage> buildInputStages(DruidQueryGenerator.DruidNodeStack stack) {
        ArrayList<LogicalStage> inputStages = new ArrayList<LogicalStage>();
        List inputs = stack.getNode().getInputs();
        for (RelNode input : inputs) {
            stack.push((DruidLogicalNode)input, inputStages.size());
            inputStages.add(this.buildStageFor(stack));
            stack.pop();
        }
        return inputStages;
    }

    private Optional<ReadStage> translateTableScan(DruidTableScan node) {
        SourceDescProducer.SourceDesc sd = node.getSourceDesc(this.plannerContext, Collections.emptyList());
        TableDataSource ids = (TableDataSource)sd.dataSource;
        TableInputSpec inputSpec = new TableInputSpec(ids.getName(), (List<Interval>)Intervals.ONLY_ETERNITY, null, null);
        ReadStage stage = new ReadStage(sd.rowSignature, LogicalInputSpec.of(inputSpec));
        return Optional.of(stage);
    }

    private Optional<ReadStage> translateValues(DruidValues node) {
        SourceDescProducer.SourceDesc sd = node.getSourceDesc(this.plannerContext, Collections.emptyList());
        InlineDataSource ids = (InlineDataSource)sd.dataSource;
        InlineInputSpec inputSpec = new InlineInputSpec(ids);
        ReadStage stage = new ReadStage(sd.rowSignature, LogicalInputSpec.of(inputSpec));
        return Optional.of(stage);
    }
}

