/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.util.SettableLongVirtualColumn;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.Unit;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.TooManyRowsInAWindowFault;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.operator.OffsetLimit;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.rowsandcols.ConcatRowsAndColumns;
import org.apache.druid.query.rowsandcols.LazilyDecoratedRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.concrete.RowBasedFrameRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ColumnSelectorFactoryMaker;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;

public class WindowOperatorQueryFrameProcessor
implements FrameProcessor<Object> {
    private static final Logger log = new Logger(WindowOperatorQueryFrameProcessor.class);
    private final List<OperatorFactory> operatorFactoryList;
    private final ArrayList<RowsAndColumns> resultRowAndCols;
    private final RowsAndColumnsBuilder frameRowsAndColsBuilder;
    private final ReadableFrameChannel inputChannel;
    private final WritableFrameChannel outputChannel;
    private final FrameWriterFactory frameWriterFactory;
    private final FrameReader frameReader;
    private final int maxRowsMaterialized;
    private FrameWriter frameWriter = null;
    private final VirtualColumns frameWriterVirtualColumns;
    private final SettableLongVirtualColumn partitionBoostVirtualColumn;
    private Operator operator = null;
    final AtomicInteger rowId = new AtomicInteger(0);

    public WindowOperatorQueryFrameProcessor(QueryContext queryContext, ReadableFrameChannel inputChannel, WritableFrameChannel outputChannel, FrameWriterFactory frameWriterFactory, FrameReader frameReader, ObjectMapper jsonMapper, List<OperatorFactory> operatorFactoryList) {
        this.inputChannel = inputChannel;
        this.outputChannel = outputChannel;
        this.frameWriterFactory = frameWriterFactory;
        this.resultRowAndCols = new ArrayList();
        this.maxRowsMaterialized = MultiStageQueryContext.getMaxRowsMaterializedInWindow(queryContext);
        this.operatorFactoryList = operatorFactoryList;
        this.frameRowsAndColsBuilder = new RowsAndColumnsBuilder(this.maxRowsMaterialized);
        this.frameReader = frameReader;
        this.partitionBoostVirtualColumn = new SettableLongVirtualColumn("__boost");
        ArrayList<Object> frameWriterVirtualColumns = new ArrayList<Object>();
        VirtualColumn segmentGranularityVirtualColumn = QueryKitUtils.makeSegmentGranularityVirtualColumn(jsonMapper, queryContext);
        if (segmentGranularityVirtualColumn != null) {
            frameWriterVirtualColumns.add(segmentGranularityVirtualColumn);
        }
        frameWriterVirtualColumns.add(this.partitionBoostVirtualColumn);
        this.frameWriterVirtualColumns = VirtualColumns.create(frameWriterVirtualColumns);
        this.initialiseOperator();
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.singletonList(this.inputChannel);
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel);
    }

    public ReturnOrAwait<Object> runIncrementally(IntSet readableInputs) throws IOException {
        if (this.frameHasRowsPendingFlush()) {
            this.flushAllRowsAndCols();
            return ReturnOrAwait.runAgain();
        }
        if (this.inputChannel.canRead()) {
            Frame frame = this.inputChannel.read();
            LazilyDecoratedRowsAndColumns ldrc = this.convertRowFrameToRowsAndColumns(frame);
            this.frameRowsAndColsBuilder.add((RowsAndColumns)ldrc);
            if (this.needToProcessBatch()) {
                this.runAllOpsOnBatch();
                if (this.inputChannel.isFinished()) {
                    return ReturnOrAwait.runAgain();
                }
                this.flushAllRowsAndCols();
            }
            return ReturnOrAwait.runAgain();
        }
        if (this.inputChannel.isFinished()) {
            if (this.rowId.get() == 0) {
                this.runAllOpsOnBatch();
            }
            if (this.frameHasRowsPendingFlush()) {
                return ReturnOrAwait.runAgain();
            }
            return ReturnOrAwait.returnObject((Object)Unit.instance());
        }
        return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
    }

    private void initialiseOperator() {
        this.operator = new Operator(){

            @Nullable
            public Closeable goOrContinue(Closeable continuationObject, Operator.Receiver receiver) {
                RowsAndColumns rac = WindowOperatorQueryFrameProcessor.this.frameRowsAndColsBuilder.build();
                WindowOperatorQueryFrameProcessor.ensureMaxRowsInAWindowConstraint(rac.numRows(), WindowOperatorQueryFrameProcessor.this.maxRowsMaterialized);
                receiver.push(rac);
                if (WindowOperatorQueryFrameProcessor.this.inputChannel.isFinished()) {
                    receiver.completed();
                    return null;
                }
                return () -> {};
            }
        };
        for (OperatorFactory of : this.operatorFactoryList) {
            this.operator = of.wrap(this.operator);
        }
    }

    private void runAllOpsOnBatch() {
        this.operator.goOrContinue(null, new Operator.Receiver(){

            public Operator.Signal push(RowsAndColumns rac) {
                WindowOperatorQueryFrameProcessor.this.resultRowAndCols.add(rac);
                return Operator.Signal.GO;
            }

            public void completed() {
                try {
                    WindowOperatorQueryFrameProcessor.this.flushAllRowsAndCols();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void flushAllRowsAndCols() throws IOException {
        ConcatRowsAndColumns rac = new ConcatRowsAndColumns(this.resultRowAndCols);
        this.createFrameWriterIfNeeded((RowsAndColumns)rac);
        this.writeRacToFrame((RowsAndColumns)rac);
    }

    private void createFrameWriterIfNeeded(RowsAndColumns rac) {
        if (this.frameWriter == null) {
            ColumnSelectorFactoryMaker csfm = ColumnSelectorFactoryMaker.fromRAC((RowsAndColumns)rac);
            ColumnSelectorFactory frameWriterColumnSelectorFactory = csfm.make(this.rowId);
            ColumnSelectorFactory frameWriterColumnSelectorFactoryWithVirtualColumns = this.frameWriterVirtualColumns.wrap(frameWriterColumnSelectorFactory);
            this.frameWriter = this.frameWriterFactory.newFrameWriter(frameWriterColumnSelectorFactoryWithVirtualColumns);
        }
    }

    public void writeRacToFrame(RowsAndColumns rac) throws IOException {
        int numRows = rac.numRows();
        while (this.rowId.get() < numRows) {
            if (this.frameWriter.addSelection()) {
                this.incrementBoostColumn();
                this.rowId.incrementAndGet();
                continue;
            }
            if (this.frameWriter.getNumRows() > 0) {
                this.flushFrameWriter();
                this.createFrameWriterIfNeeded(rac);
                if (this.frameWriter.addSelection()) {
                    this.incrementBoostColumn();
                    this.rowId.incrementAndGet();
                    return;
                }
                throw new FrameRowTooLargeException(this.frameWriterFactory.allocatorCapacity());
            }
            throw new FrameRowTooLargeException(this.frameWriterFactory.allocatorCapacity());
        }
        this.flushFrameWriter();
        this.clearRACBuffers();
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[]{this.frameWriter});
    }

    private long flushFrameWriter() throws IOException {
        if (this.frameWriter == null || this.frameWriter.getNumRows() <= 0) {
            if (this.frameWriter != null) {
                this.frameWriter.close();
                this.frameWriter = null;
            }
            return 0L;
        }
        Frame frame = Frame.wrap((byte[])this.frameWriter.toByteArray());
        ((WritableFrameChannel)Iterables.getOnlyElement(this.outputChannels())).write(new FrameWithPartition(frame, -1));
        this.frameWriter.close();
        this.frameWriter = null;
        return frame.numRows();
    }

    private LazilyDecoratedRowsAndColumns convertRowFrameToRowsAndColumns(Frame frame) {
        RowSignature signature = this.frameReader.signature();
        RowBasedFrameRowsAndColumns frameRowsAndColumns = new RowBasedFrameRowsAndColumns(frame, signature);
        LazilyDecoratedRowsAndColumns ldrc = new LazilyDecoratedRowsAndColumns((RowsAndColumns)frameRowsAndColumns, null, null, null, OffsetLimit.limit((int)Integer.MAX_VALUE), null, null, Long.valueOf(this.frameWriterFactory.allocatorCapacity()));
        return ldrc;
    }

    private static void ensureMaxRowsInAWindowConstraint(int numRowsInWindow, int maxRowsMaterialized) {
        if (numRowsInWindow > maxRowsMaterialized) {
            throw new MSQException(new TooManyRowsInAWindowFault(numRowsInWindow, maxRowsMaterialized));
        }
    }

    private boolean needToProcessBatch() {
        return this.frameRowsAndColsBuilder.getNumRows() >= this.maxRowsMaterialized / 2;
    }

    private void incrementBoostColumn() {
        this.partitionBoostVirtualColumn.setValue(this.partitionBoostVirtualColumn.getValue() + 1L);
    }

    private boolean frameHasRowsPendingFlush() {
        return this.frameWriter != null && this.frameWriter.getNumRows() > 0;
    }

    private void clearRACBuffers() {
        this.resultRowAndCols.clear();
        this.rowId.set(0);
    }

    private static class RowsAndColumnsBuilder {
        private final List<RowsAndColumns> racList = new ArrayList<RowsAndColumns>();
        private int totalRows = 0;
        private final int maxRowsMaterialized;

        public RowsAndColumnsBuilder(int maxRowsMaterialized) {
            this.maxRowsMaterialized = maxRowsMaterialized;
        }

        public void add(RowsAndColumns rac) {
            this.racList.add(rac);
            this.totalRows += rac.numRows();
            WindowOperatorQueryFrameProcessor.ensureMaxRowsInAWindowConstraint(this.getNumRows(), this.maxRowsMaterialized);
        }

        public int getNumRows() {
            return this.totalRows;
        }

        public RowsAndColumns build() {
            ConcatRowsAndColumns concatRowsAndColumns = new ConcatRowsAndColumns(new ArrayList<RowsAndColumns>(this.racList));
            this.clear();
            return concatRowsAndColumns;
        }

        public void clear() {
            this.racList.clear();
            this.totalRows = 0;
        }
    }
}

