/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.msq.exec.QueryKitSpecFactory;
import org.apache.druid.msq.indexing.destination.MSQTerminalStageSpecFactory;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.sql.MSQTaskQueryKitSpecFactory;
import org.apache.druid.msq.sql.MSQTaskQueryMaker;
import org.apache.druid.msq.util.ArrayIngestMode;
import org.apache.druid.msq.util.DimensionSchemaUtils;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.QueryContext;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.NativeSqlEngine;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngines;
import org.apache.druid.sql.destination.IngestDestination;
import org.apache.druid.sql.destination.TableDestination;

public class MSQTaskSqlEngine
implements SqlEngine {
    public static final Set<String> SYSTEM_CONTEXT_PARAMETERS = ImmutableSet.builder().addAll((Iterable)NativeSqlEngine.SYSTEM_CONTEXT_PARAMETERS).add((Object)"__timeColumn").add((Object)"__exportFileFormat").add((Object)"isReindex").build();
    public static final List<String> TASK_STRUCT_FIELD_NAMES = ImmutableList.of((Object)"TASK");
    public static final String NAME = "msq-task";
    private final OverlordClient overlordClient;
    private final ObjectMapper jsonMapper;
    private final MSQTerminalStageSpecFactory terminalStageSpecFactory;
    private final QueryKitSpecFactory queryKitSpecFactory;
    private final SqlToolbox sqlToolbox;

    @Inject
    public MSQTaskSqlEngine(OverlordClient overlordClient, ObjectMapper jsonMapper, MSQTerminalStageSpecFactory terminalStageSpecFactory, MSQTaskQueryKitSpecFactory queryKitSpecFactory, SqlToolbox sqlToolbox) {
        this.overlordClient = overlordClient;
        this.jsonMapper = jsonMapper;
        this.terminalStageSpecFactory = terminalStageSpecFactory;
        this.queryKitSpecFactory = queryKitSpecFactory;
        this.sqlToolbox = sqlToolbox;
    }

    public String name() {
        return NAME;
    }

    public void validateContext(Map<String, Object> queryContext) {
        SqlEngines.validateNoSpecialContextKeys(queryContext, SYSTEM_CONTEXT_PARAMETERS);
    }

    public RelDataType resultTypeForSelect(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
        return MSQTaskSqlEngine.getMSQStructType(typeFactory);
    }

    public RelDataType resultTypeForInsert(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
        return MSQTaskSqlEngine.getMSQStructType(typeFactory);
    }

    public boolean featureAvailable(EngineFeature feature) {
        switch (feature) {
            case ALLOW_BINDABLE_PLAN: 
            case ALLOW_BROADCAST_RIGHTY_JOIN: 
            case TIMESERIES_QUERY: 
            case TOPN_QUERY: 
            case TIME_BOUNDARY_QUERY: 
            case GROUPING_SETS: 
            case ALLOW_TOP_LEVEL_UNION_ALL: 
            case GROUPBY_IMPLICITLY_SORTS: {
                return false;
            }
            case WINDOW_FUNCTIONS: 
            case WINDOW_LEAF_OPERATOR: 
            case UNNEST: 
            case CAN_SELECT: 
            case CAN_INSERT: 
            case CAN_REPLACE: 
            case READ_EXTERNAL_DATA: 
            case WRITE_EXTERNAL_DATA: 
            case SCAN_ORDER_BY_NON_TIME: 
            case SCAN_NEEDS_SIGNATURE: {
                return true;
            }
        }
        throw SqlEngines.generateUnrecognizedFeatureException((String)MSQTaskSqlEngine.class.getSimpleName(), (EngineFeature)feature);
    }

    public QueryMaker buildQueryMakerForSelect(RelRoot relRoot, PlannerContext plannerContext) {
        MSQTaskSqlEngine.validateSelect(plannerContext);
        return new MSQTaskQueryMaker(null, this.overlordClient, plannerContext, this.jsonMapper, (List<Map.Entry<Integer, String>>)relRoot.fields, this.terminalStageSpecFactory, this.queryKitSpecFactory);
    }

    public OverlordClient overlordClient() {
        return this.overlordClient;
    }

    public QueryMaker buildQueryMakerForInsert(IngestDestination destination, RelRoot relRoot, PlannerContext plannerContext) {
        MSQTaskSqlEngine.validateInsert(relRoot, destination instanceof TableDestination ? plannerContext.getPlannerToolbox().rootSchema().getNamedSchema(plannerContext.getPlannerToolbox().druidSchemaName()).getSchema().getTable(((TableDestination)destination).getTableName()) : null, plannerContext);
        return new MSQTaskQueryMaker(destination, this.overlordClient, plannerContext, this.jsonMapper, (List<Map.Entry<Integer, String>>)relRoot.fields, this.terminalStageSpecFactory, this.queryKitSpecFactory);
    }

    public SqlStatementFactory getSqlStatementFactory() {
        return new SqlStatementFactory(this.sqlToolbox.withEngine((SqlEngine)this));
    }

    private static void validateSelect(PlannerContext plannerContext) {
        if (plannerContext.queryContext().containsKey("sqlInsertSegmentGranularity")) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.DEFENSIVE).build("The SELECT query's context contains invalid parameter [%s] which is supposed to be populated by Druid for INSERT queries. If the user is seeing this exception, that means there's a bug in Druid that is populating the query context with the segment's granularity.", new Object[]{"sqlInsertSegmentGranularity"});
        }
    }

    private static void validateInsert(RelRoot relRoot, @Nullable Table targetTable, PlannerContext plannerContext) {
        Map<String, Integer> outputFieldMap = MSQTaskSqlEngine.validateNoDuplicateAliases((List<Map.Entry<Integer, String>>)relRoot.fields);
        int timeColumnIndex = MSQTaskSqlEngine.getTimeColumnIndex(outputFieldMap);
        Granularity segmentGranularity = MSQTaskSqlEngine.getSegmentGranularity(plannerContext);
        MSQTaskSqlEngine.validateTimeColumnType(relRoot.rel, timeColumnIndex);
        MSQTaskSqlEngine.validateTimeColumnExistsIfNeeded(timeColumnIndex, segmentGranularity);
        MSQTaskSqlEngine.validateLimitAndOffset(relRoot.rel, Granularities.ALL.equals(segmentGranularity));
        MSQTaskSqlEngine.validateTypeChanges(relRoot.rel, (List<Map.Entry<Integer, String>>)relRoot.fields, targetTable, plannerContext);
        MSQTaskSqlEngine.validateSortOrderBeginsWithTimeIfRequired((List<Map.Entry<Integer, String>>)relRoot.fields, relRoot.collation, plannerContext);
    }

    private static Map<String, Integer> validateNoDuplicateAliases(List<Map.Entry<Integer, String>> fieldMappings) {
        Object2IntOpenHashMap retVal = new Object2IntOpenHashMap();
        for (Map.Entry<Integer, String> field : fieldMappings) {
            if (retVal.put(field.getValue(), field.getKey()) == null) continue;
            throw InvalidSqlInput.exception((String)"Duplicate field in SELECT: [%s]", (Object[])new Object[]{field.getValue()});
        }
        return retVal;
    }

    private static void validateTimeColumnType(RelNode rootRel, int timeColumnIndex) {
        if (timeColumnIndex < 0) {
            return;
        }
        SqlTypeName timeType = ((RelDataTypeField)rootRel.getRowType().getFieldList().get(timeColumnIndex)).getType().getSqlTypeName();
        if (timeType != SqlTypeName.TIMESTAMP) {
            throw InvalidSqlInput.exception((String)"Field[%s] was the wrong type[%s], expected TIMESTAMP", (Object[])new Object[]{"__time", timeType});
        }
    }

    private static void validateTimeColumnExistsIfNeeded(int timeColumnIndex, Granularity segmentGranularity) {
        boolean hasSegmentGranularity;
        boolean bl = hasSegmentGranularity = !Granularities.ALL.equals(segmentGranularity);
        if (hasSegmentGranularity && timeColumnIndex < 0) {
            throw InvalidInput.exception((String)"The granularity [%s] specified in the PARTITIONED BY clause of the INSERT query is different from ALL. Therefore, the query must specify a time column (named __time).", (Object[])new Object[]{segmentGranularity});
        }
    }

    private static void validateLimitAndOffset(RelNode rootRel, boolean limitOk) {
        RelNode projectInput;
        Project project;
        Sort sort = null;
        if (rootRel instanceof Sort) {
            sort = (Sort)rootRel;
        } else if (rootRel instanceof Project && (project = (Project)rootRel).isMapping() && (projectInput = project.getInput()) instanceof Sort) {
            sort = (Sort)projectInput;
        }
        if (sort != null && sort.fetch != null && !limitOk) {
            throw InvalidSqlInput.exception((String)"INSERT and REPLACE queries cannot have a LIMIT unless PARTITIONED BY is \"ALL\".", (Object[])new Object[0]);
        }
        if (sort != null && sort.offset != null) {
            throw InvalidSqlInput.exception((String)"INSERT and REPLACE queries cannot have an OFFSET.", (Object[])new Object[0]);
        }
    }

    private static void validateTypeChanges(RelNode rootRel, List<Map.Entry<Integer, String>> fieldMappings, @Nullable Table targetTable, PlannerContext plannerContext) {
        if (targetTable == null) {
            return;
        }
        Set<String> columnsExcludedFromTypeVerification = MultiStageQueryContext.getColumnsExcludedFromTypeVerification(plannerContext.queryContext());
        ArrayIngestMode arrayIngestMode = MultiStageQueryContext.getArrayIngestMode(plannerContext.queryContext());
        for (Map.Entry<Integer, String> fieldMapping : fieldMappings) {
            int columnIndex = fieldMapping.getKey();
            String columnName = fieldMapping.getValue();
            RelDataTypeField oldSqlTypeField = targetTable.getRowType(DruidTypeSystem.TYPE_FACTORY).getField(columnName, true, false);
            if (columnsExcludedFromTypeVerification.contains(columnName) || oldSqlTypeField == null) continue;
            ColumnType oldDruidType = Calcites.getColumnTypeForRelDataType((RelDataType)oldSqlTypeField.getType());
            RelDataType newSqlType = ((RelDataTypeField)rootRel.getRowType().getFieldList().get(columnIndex)).getType();
            ColumnType newDruidType = DimensionSchemaUtils.getDimensionType(columnName, Calcites.getColumnTypeForRelDataType((RelDataType)newSqlType), arrayIngestMode);
            if ((!newDruidType.isArray() || !oldDruidType.is((TypeDescriptor)ValueType.STRING)) && (!newDruidType.is((TypeDescriptor)ValueType.STRING) || !oldDruidType.isArray())) continue;
            StringBuilder messageBuilder = new StringBuilder(StringUtils.format((String)"Cannot write into field[%s] using type[%s] and arrayIngestMode[%s], since the existing type is[%s]", (Object[])new Object[]{columnName, newSqlType, StringUtils.toLowerCase((String)arrayIngestMode.toString()), oldSqlTypeField.getType()}));
            if (newDruidType.is((TypeDescriptor)ValueType.STRING) && newSqlType.getSqlTypeName() == SqlTypeName.ARRAY && arrayIngestMode == ArrayIngestMode.MVD) {
                messageBuilder.append(". Try setting arrayIngestMode to[array] to retain the SQL type[").append(newSqlType).append("]");
            } else if (newDruidType.is((TypeDescriptor)ValueType.ARRAY) && oldDruidType.is((TypeDescriptor)ValueType.STRING) && arrayIngestMode == ArrayIngestMode.ARRAY) {
                messageBuilder.append(". Try wrapping this field using ARRAY_TO_MV(...) AS ").append(CalciteSqlDialect.DEFAULT.quoteIdentifier(columnName));
            } else if (newDruidType.is((TypeDescriptor)ValueType.STRING) && oldDruidType.is((TypeDescriptor)ValueType.ARRAY)) {
                messageBuilder.append(". Try");
                if (arrayIngestMode == ArrayIngestMode.MVD) {
                    messageBuilder.append(" setting arrayIngestMode to[array] and");
                }
                messageBuilder.append(" adjusting your query to make this column an ARRAY instead of VARCHAR");
            }
            messageBuilder.append(". See https://druid.apache.org/docs/latest/querying/arrays#arrayingestmode for more details about this check and how to override it if needed.");
            throw InvalidSqlInput.exception((String)StringUtils.encodeForFormat((String)messageBuilder.toString()), (Object[])new Object[0]);
        }
    }

    private static void validateSortOrderBeginsWithTimeIfRequired(List<Map.Entry<Integer, String>> fieldMappings, RelCollation rootCollation, PlannerContext plannerContext) {
        QueryContext context = plannerContext.queryContext();
        if (!MultiStageQueryContext.isForceSegmentSortByTime(context)) {
            return;
        }
        List<String> contextSortOrder = MultiStageQueryContext.getSortOrder(context);
        if (!contextSortOrder.isEmpty()) {
            boolean timeIsFirst = "__time".equals(contextSortOrder.get(0));
            if (!timeIsFirst) {
                throw InvalidSqlInput.exception((String)"Context parameter[%s] must start with[%s] unless context parameter[%s] is set to[false]. %s", (Object[])new Object[]{"segmentSortOrder", "__time", "forceSegmentSortByTime", DimensionsSpec.WARNING_NON_TIME_SORT_ORDER});
            }
        } else if (!rootCollation.getFieldCollations().isEmpty()) {
            int timePositionInRow = -1;
            for (int i = 0; i < fieldMappings.size(); ++i) {
                Map.Entry<Integer, String> entry = fieldMappings.get(i);
                if (!"__time".equals(entry.getValue())) continue;
                timePositionInRow = i;
                break;
            }
            int timePositionInCollation = -1;
            for (int i = 0; i < rootCollation.getFieldCollations().size(); ++i) {
                if (((RelFieldCollation)rootCollation.getFieldCollations().get(i)).getFieldIndex() != timePositionInRow) continue;
                timePositionInCollation = i;
                break;
            }
            if (timePositionInCollation > 0) {
                throw InvalidSqlInput.exception((String)"Sort order (CLUSTERED BY) cannot include[%s] in position[%d] unless context parameter[%s] is set to[false]. %s", (Object[])new Object[]{"__time", timePositionInCollation, "forceSegmentSortByTime", DimensionsSpec.WARNING_NON_TIME_SORT_ORDER});
            }
        }
    }

    private static int getTimeColumnIndex(Map<String, Integer> outputFieldMapping) {
        Integer position = outputFieldMapping.get("__time");
        return position != null ? position : -1;
    }

    private static Granularity getSegmentGranularity(PlannerContext plannerContext) {
        try {
            return QueryKitUtils.getSegmentGranularityFromContext(plannerContext.getJsonMapper(), plannerContext.queryContextMap());
        }
        catch (Exception e) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.DEFENSIVE).build((Throwable)e, "[%s] is not a valid value for [%s]", new Object[]{plannerContext.queryContext().get("sqlInsertSegmentGranularity"), "sqlInsertSegmentGranularity"});
        }
    }

    private static RelDataType getMSQStructType(RelDataTypeFactory typeFactory) {
        return typeFactory.createStructType((List)ImmutableList.of((Object)Calcites.createSqlType((RelDataTypeFactory)typeFactory, (SqlTypeName)SqlTypeName.VARCHAR)), TASK_STRUCT_FIELD_NAMES);
    }
}

