/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.base.Strings;
import io.netty.util.SuppressForbidden;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.IllegalFormatException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.druid.java.util.common.ISE;

public class StringUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    @Deprecated
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final String UTF8_STRING = StandardCharsets.UTF_8.toString();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();

    public static int estimatedBinaryLengthAsUTF8(String value) {
        int length = 0;
        for (int i = 0; i < value.length(); ++i) {
            char var10 = value.charAt(i);
            if (var10 < '\u0080') {
                ++length;
                continue;
            }
            if (var10 < '\u0800') {
                length += 2;
                continue;
            }
            if (Character.isSurrogate(var10)) {
                length += 4;
                ++i;
                continue;
            }
            length += 3;
        }
        return length;
    }

    public static byte[] toUtf8WithNullToEmpty(String string) {
        return string == null ? EMPTY_BYTES : StringUtils.toUtf8(string);
    }

    public static int compareUnicode(String a, String b) {
        int commonLength = Math.min(a.length(), b.length());
        for (int i = 0; i < commonLength; ++i) {
            int cmp;
            int char2;
            int char1 = a.charAt(i) & 0xFFFF;
            if (char1 != (char2 = b.charAt(i) & 0xFFFF) && char1 >= 55296 && char2 >= 55296) {
                if (!Character.isSurrogate((char)char1)) {
                    char1 -= 10240;
                }
                if (!Character.isSurrogate((char)char2)) {
                    char2 -= 10240;
                }
            }
            if ((cmp = char1 - char2) == 0) continue;
            return cmp;
        }
        return Integer.compare(a.length(), b.length());
    }

    public static int compareUtf8(byte[] a, byte[] b) {
        int commonLength = Math.min(a.length, b.length);
        for (int i = 0; i < commonLength; ++i) {
            byte byte1 = a[i];
            byte byte2 = b[i];
            int cmp = (byte1 & 0xFF) - (byte2 & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(a.length, b.length);
    }

    public static int compareUtf8UsingJavaStringOrdering(byte[] a, byte[] b) {
        int commonLength = Math.min(a.length, b.length);
        for (int i = 0; i < commonLength; ++i) {
            int cmp = StringUtils.compareUtf8UsingJavaStringOrdering(a[i], b[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(a.length, b.length);
    }

    public static int compareUtf8UsingJavaStringOrdering(ByteBuffer buf1, int position1, int length1, ByteBuffer buf2, int position2, int length2) {
        int commonLength = Math.min(length1, length2);
        for (int i = 0; i < commonLength; ++i) {
            int cmp = StringUtils.compareUtf8UsingJavaStringOrdering(buf1.get(position1 + i), buf2.get(position2 + i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(length1, length2);
    }

    public static int compareUtf8UsingJavaStringOrdering(byte byte1, byte byte2) {
        int ubyte1 = byte1 & 0xFF;
        int ubyte2 = byte2 & 0xFF;
        if (ubyte1 != ubyte2 && ubyte1 >= 238 && ubyte2 >= 238) {
            if (ubyte1 == 238 || ubyte1 == 239) {
                ubyte1 += 255;
            }
            if (ubyte2 == 238 || ubyte2 == 239) {
                ubyte2 += 255;
            }
        }
        return ubyte1 - ubyte2;
    }

    public static String fromUtf8(byte[] bytes) {
        return StringUtils.fromUtf8(bytes, 0, bytes.length);
    }

    public static String fromUtf8(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fromUtf8(ByteBuffer buffer, int numBytes) {
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return StringUtils.fromUtf8(bytes);
    }

    public static String fromUtf8(ByteBuffer buffer) {
        return StringUtils.fromUtf8(buffer, buffer.remaining());
    }

    @Nullable
    public static String fromUtf8Nullable(@Nullable ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return StringUtils.fromUtf8(buffer, buffer.remaining());
    }

    public static byte[] toUtf8(String string) {
        try {
            return string.getBytes(UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static ByteBuffer toUtf8ByteBuffer(@Nullable String string) {
        return string == null ? null : ByteBuffer.wrap(StringUtils.toUtf8(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int toUtf8WithLimit(String string, ByteBuffer byteBuffer) {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int originalPosition = byteBuffer.position();
        int originalLimit = byteBuffer.limit();
        int maxBytes = byteBuffer.remaining();
        try {
            char[] chars = string.toCharArray();
            CharBuffer charBuffer = CharBuffer.wrap(chars);
            encoder.encode(charBuffer, byteBuffer, true);
            int bytesWritten = byteBuffer.position() - originalPosition;
            assert (bytesWritten <= maxBytes);
            int n = bytesWritten;
            return n;
        }
        finally {
            byteBuffer.position(originalPosition);
            byteBuffer.limit(originalLimit);
        }
    }

    @Nullable
    public static byte[] toUtf8Nullable(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return StringUtils.toUtf8(string);
    }

    public static String format(String message, Object ... formatArgs) {
        return String.format(Locale.ENGLISH, message, formatArgs);
    }

    public static String nonStrictFormat(String message, Object ... formatArgs) {
        if (formatArgs == null || formatArgs.length == 0) {
            return message;
        }
        try {
            return String.format(Locale.ENGLISH, message, formatArgs);
        }
        catch (IllegalFormatException e) {
            StringBuilder bob = new StringBuilder(message);
            for (Object formatArg : formatArgs) {
                bob.append("; ").append(formatArg);
            }
            return bob.toString();
        }
    }

    @Nullable
    public static String encodeForFormat(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return StringUtils.replaceChar(s, '%', "%%");
    }

    public static String toLowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public static String toUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    @Nullable
    public static String urlEncode(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return StringUtils.replace(URLEncoder.encode(s, StandardCharsets.UTF_8), "+", "%20");
    }

    @Nullable
    public static String urlDecode(String s) {
        if (s == null) {
            return null;
        }
        return URLDecoder.decode(s, StandardCharsets.UTF_8);
    }

    public static String maybeRemoveLeadingSlash(String s) {
        return s != null && s.startsWith("/") ? s.substring(1) : s;
    }

    public static String maybeRemoveTrailingSlash(String s) {
        return s != null && s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
    }

    public static String maybeAppendTrailingSlash(String s) {
        return s != null && !s.endsWith("/") ? s + "/" : s;
    }

    public static String removeChar(String s, char c) {
        return StringUtils.replace(s, String.valueOf(c), "");
    }

    public static String replaceChar(String s, char c, String replacement) {
        return StringUtils.replace(s, String.valueOf(c), replacement);
    }

    @SuppressForbidden(reason="String#replace")
    public static String replace(String s, String target, String replacement) {
        return s.replace(target, replacement);
    }

    public static String nullToEmptyNonDruidDataString(@Nullable String string) {
        return Strings.nullToEmpty((String)string);
    }

    @Nullable
    public static String emptyToNullNonDruidDataString(@Nullable String string) {
        return Strings.emptyToNull((String)string);
    }

    public static String utf8Base64(String input) {
        return StringUtils.fromUtf8(StringUtils.encodeBase64(StringUtils.toUtf8(input)));
    }

    public static byte[] encodeBase64(byte[] input) {
        return BASE64_ENCODER.encode(input);
    }

    public static String encodeBase64String(byte[] input) {
        return BASE64_ENCODER.encodeToString(input);
    }

    public static byte[] decodeBase64(byte[] input) {
        return BASE64_DECODER.decode(input);
    }

    public static byte[] decodeBase64String(String input) {
        return BASE64_DECODER.decode(input);
    }

    public static String repeat(String s, int count) {
        int copied;
        if (count < 0) {
            throw new IllegalArgumentException("count is negative, " + count);
        }
        if (count == 1) {
            return s;
        }
        byte[] value = s.getBytes(StandardCharsets.UTF_8);
        int len = value.length;
        if (len == 0 || count == 0) {
            return "";
        }
        if (len == 1) {
            byte[] single = new byte[count];
            Arrays.fill(single, value[0]);
            return new String(single, StandardCharsets.UTF_8);
        }
        if (Integer.MAX_VALUE / count < len) {
            throw new RuntimeException("The produced string is too large.");
        }
        int limit = len * count;
        byte[] multiple = new byte[limit];
        System.arraycopy(value, 0, multiple, 0, len);
        for (copied = len; copied < limit - copied; copied <<= 1) {
            System.arraycopy(multiple, 0, multiple, copied, copied);
        }
        System.arraycopy(multiple, 0, multiple, copied, limit - copied);
        return new String(multiple, StandardCharsets.UTF_8);
    }

    @Nonnull
    public static String lpad(@Nonnull String base, int len, @Nonnull String pad) {
        int i;
        if (len <= 0) {
            return "";
        }
        int pos = Math.max(len - base.length(), 0);
        if (pos > 0 && pad.isEmpty()) {
            return base;
        }
        char[] data = new char[len];
        for (i = 0; i < pos; i += pad.length()) {
            for (int j = 0; j < pad.length() && j < pos - i; ++j) {
                data[i + j] = pad.charAt(j);
            }
        }
        for (i = 0; pos + i < len && i < base.length(); ++i) {
            data[pos + i] = base.charAt(i);
        }
        return new String(data);
    }

    @Nonnull
    public static String rpad(@Nonnull String base, int len, @Nonnull String pad) {
        int i;
        if (len <= 0) {
            return "";
        }
        int paddingLen = Math.max(len - base.length(), 0);
        if (paddingLen > 0 && pad.isEmpty()) {
            return base;
        }
        char[] data = new char[len];
        for (i = len - paddingLen; i < len; i += pad.length()) {
            for (int j = 0; j < pad.length() && i + j < data.length; ++j) {
                data[i + j] = pad.charAt(j);
            }
        }
        for (i = 0; i < len && i < base.length(); ++i) {
            data[i] = base.charAt(i);
        }
        return new String(data);
    }

    @Nullable
    public static String chop(@Nullable String s, int maxBytes) {
        if (s == null) {
            return null;
        }
        byte[] bytes = new byte[maxBytes];
        int len = StringUtils.toUtf8WithLimit(s, ByteBuffer.wrap(bytes));
        return new String(bytes, 0, len, StandardCharsets.UTF_8);
    }

    @Nullable
    public static String fastLooseChop(@Nullable String s, int maxBytes) {
        if (s == null || s.length() <= maxBytes) {
            return s;
        }
        return s.substring(0, maxBytes);
    }

    public static String getResource(Object ref, String resource) {
        try {
            InputStream is = ref.getClass().getResourceAsStream(resource);
            if (is == null) {
                throw new ISE("Resource not found: [%s]", resource);
            }
            return IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ISE(e, "Cannot load resource: [%s]", resource);
        }
    }

    public static String escapeSql(String str) {
        return str == null ? null : StringUtils.replace(str, "'", "''");
    }

    public static String escapeHtml(String value) {
        return StringEscapeUtils.escapeHtml4((String)value);
    }
}

