/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprEvalVector;

public class ExprEvalBindingVector<T>
implements ExprEvalVector<T> {
    private final ExpressionType expressionType;
    private final Expr.VectorInputBinding bindings;
    private final String bindingName;
    @Nullable
    private long[] longs;
    @Nullable
    private double[] doubles;
    @Nullable
    private boolean[] numericNulls;

    public ExprEvalBindingVector(ExpressionType expressionType, Expr.VectorInputBinding bindings, String name) {
        this.expressionType = expressionType;
        this.bindings = bindings;
        this.bindingName = name;
    }

    @Override
    public ExpressionType getType() {
        return this.expressionType;
    }

    @Override
    public T values() {
        if (this.expressionType.is(ExprType.LONG)) {
            return (T)this.getLongVector();
        }
        if (this.expressionType.is(ExprType.DOUBLE)) {
            return (T)this.getDoubleVector();
        }
        return (T)this.bindings.getObjectVector(this.bindingName);
    }

    @Override
    public long[] getLongVector() {
        if (this.expressionType.isNumeric()) {
            return this.bindings.getLongVector(this.bindingName);
        }
        this.computeNumbers();
        return this.longs;
    }

    @Override
    public double[] getDoubleVector() {
        if (this.expressionType.isNumeric()) {
            return this.bindings.getDoubleVector(this.bindingName);
        }
        this.computeNumbers();
        return this.doubles;
    }

    @Override
    @Nullable
    public boolean[] getNullVector() {
        if (this.expressionType.isNumeric()) {
            return this.bindings.getNullVector(this.bindingName);
        }
        this.computeNumbers();
        return this.numericNulls;
    }

    @Override
    public Object[] getObjectVector() {
        if (this.expressionType.is(ExprType.LONG)) {
            long[] values = this.bindings.getLongVector(this.bindingName);
            boolean[] nulls = this.bindings.getNullVector(this.bindingName);
            Object[] objects = new Long[values.length];
            if (nulls != null) {
                for (int i = 0; i < values.length; ++i) {
                    objects[i] = nulls[i] ? null : Long.valueOf(values[i]);
                }
            } else {
                for (int i = 0; i < values.length; ++i) {
                    objects[i] = values[i];
                }
            }
            return objects;
        }
        if (this.expressionType.is(ExprType.DOUBLE)) {
            double[] values = this.bindings.getDoubleVector(this.bindingName);
            boolean[] nulls = this.bindings.getNullVector(this.bindingName);
            Object[] objects = new Double[values.length];
            if (nulls != null) {
                for (int i = 0; i < values.length; ++i) {
                    objects[i] = nulls[i] ? null : Double.valueOf(values[i]);
                }
            } else {
                for (int i = 0; i < values.length; ++i) {
                    objects[i] = values[i];
                }
            }
            return objects;
        }
        return this.bindings.getObjectVector(this.bindingName);
    }

    private void computeNumbers() {
        Object[] values = this.getObjectVector();
        if (this.longs == null) {
            this.longs = new long[values.length];
            this.doubles = new double[values.length];
            this.numericNulls = new boolean[values.length];
            boolean isString = this.expressionType.is(ExprType.STRING);
            for (int i = 0; i < values.length; ++i) {
                if (isString) {
                    Number n = ExprEval.computeNumber(Evals.asString(values[i]));
                    if (n != null) {
                        this.longs[i] = n.longValue();
                        this.doubles[i] = n.doubleValue();
                        this.numericNulls[i] = false;
                        continue;
                    }
                    this.longs[i] = 0L;
                    this.doubles[i] = 0.0;
                    this.numericNulls[i] = true;
                    continue;
                }
                ExprEval valueEval = ExprEval.ofType(this.expressionType, values[i]);
                this.longs[i] = valueEval.asLong();
                this.doubles[i] = valueEval.asDouble();
                this.numericNulls[i] = valueEval.isNumericNull();
            }
        }
    }
}

