/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.math.expr.SettableObjectBinding;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregator;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorInputBindings;
import org.apache.druid.query.aggregation.ExpressionLambdaBufferAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionPlan;
import org.apache.druid.segment.virtual.ExpressionPlanner;
import org.apache.druid.segment.virtual.ExpressionSelectors;

public class ExpressionLambdaAggregatorFactory
extends AggregatorFactory {
    private static final String FINALIZE_IDENTIFIER = "o";
    private static final String COMPARE_O1 = "o1";
    private static final String COMPARE_O2 = "o2";
    private static final String DEFAULT_ACCUMULATOR_ID = "__acc";
    private static final int MIN_SIZE_BYTES = 10;
    public static final HumanReadableBytes DEFAULT_MAX_SIZE_BYTES = new HumanReadableBytes(1024L);
    private final String name;
    @Nullable
    private final Set<String> fields;
    private final String accumulatorId;
    private final String foldExpressionString;
    private final String initialValueExpressionString;
    private final String initialCombineValueExpressionString;
    private final boolean isNullUnlessAggregated;
    private final boolean shouldAggregateNullInputs;
    private final boolean shouldCombineAggregateNullInputs;
    private final String combineExpressionString;
    @Nullable
    private final String compareExpressionString;
    @Nullable
    private final String finalizeExpressionString;
    private final ExprMacroTable macroTable;
    private final Supplier<ExprEval<?>> initialValue;
    private final Supplier<ExprEval<?>> initialCombineValue;
    private final Supplier<Expr> foldExpression;
    private final Supplier<Expr> combineExpression;
    private final Supplier<Expr> compareExpression;
    private final Supplier<Expr> finalizeExpression;
    private final HumanReadableBytes maxSizeBytes;
    private final ThreadLocal<SettableObjectBinding> compareBindings;
    private final ThreadLocal<SettableObjectBinding> combineBindings;
    private final ThreadLocal<SettableObjectBinding> finalizeBindings;
    private final Supplier<Expr.InputBindingInspector> finalizeInspector;

    @JsonCreator
    public ExpressionLambdaAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fields") @Nullable Set<String> fields, @JsonProperty(value="accumulatorIdentifier") @Nullable String accumulatorIdentifier, @JsonProperty(value="initialValue") String initialValue, @JsonProperty(value="initialCombineValue") @Nullable String initialCombineValue, @JsonProperty(value="isNullUnlessAggregated") @Nullable Boolean isNullUnlessAggregated, @JsonProperty(value="shouldAggregateNullInputs") @Nullable Boolean shouldAggregateNullInputs, @JsonProperty(value="shouldCombineAggregateNullInputs") @Nullable Boolean shouldCombineAggregateNullInputs, @JsonProperty(value="fold") String foldExpression, @JsonProperty(value="combine") @Nullable String combineExpression, @JsonProperty(value="compare") @Nullable String compareExpression, @JsonProperty(value="finalize") @Nullable String finalizeExpression, @JsonProperty(value="maxSizeBytes") @Nullable HumanReadableBytes maxSizeBytes, @JacksonInject ExprMacroTable macroTable) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        this.name = name;
        this.fields = fields;
        this.accumulatorId = accumulatorIdentifier != null ? accumulatorIdentifier : DEFAULT_ACCUMULATOR_ID;
        this.initialValueExpressionString = initialValue;
        this.initialCombineValueExpressionString = initialCombineValue == null ? initialValue : initialCombineValue;
        this.isNullUnlessAggregated = isNullUnlessAggregated == null || isNullUnlessAggregated != false;
        this.shouldAggregateNullInputs = shouldAggregateNullInputs == null || shouldAggregateNullInputs != false;
        this.shouldCombineAggregateNullInputs = shouldCombineAggregateNullInputs == null ? this.shouldAggregateNullInputs : shouldCombineAggregateNullInputs;
        this.foldExpressionString = foldExpression;
        if (combineExpression != null) {
            this.combineExpressionString = combineExpression;
        } else {
            Preconditions.checkArgument((fields != null && fields.size() == 1 ? 1 : 0) != 0, (Object)"Must have a single input field if no combine expression is supplied");
            this.combineExpressionString = StringUtils.replace(foldExpression, (String)Iterables.getOnlyElement(fields), name);
        }
        this.compareExpressionString = compareExpression;
        this.finalizeExpressionString = finalizeExpression;
        this.macroTable = macroTable;
        this.initialValue = Suppliers.memoize(() -> {
            Expr parsed = Parser.parse(initialValue, macroTable);
            Preconditions.checkArgument((boolean)parsed.isLiteral(), (Object)"initial value must be constant");
            return parsed.eval(InputBindings.nilBindings());
        });
        this.initialCombineValue = Suppliers.memoize(() -> {
            Expr parsed = Parser.parse(this.initialCombineValueExpressionString, macroTable);
            Preconditions.checkArgument((boolean)parsed.isLiteral(), (Object)"initial combining value must be constant");
            return parsed.eval(InputBindings.nilBindings());
        });
        this.foldExpression = Parser.lazyParse(this.foldExpressionString, macroTable);
        this.combineExpression = Parser.lazyParse(this.combineExpressionString, macroTable);
        this.compareExpression = Parser.lazyParse(this.compareExpressionString, macroTable);
        this.finalizeInspector = Suppliers.memoize(() -> InputBindings.inspectorFromTypeMap((Map<String, ExpressionType>)ImmutableMap.of((Object)FINALIZE_IDENTIFIER, (Object)((ExprEval)this.initialCombineValue.get()).type())));
        this.compareBindings = ThreadLocal.withInitial(() -> new SettableObjectBinding(2).withInspector(InputBindings.inspectorFromTypeMap((Map<String, ExpressionType>)ImmutableMap.of((Object)COMPARE_O1, (Object)((ExprEval)this.initialCombineValue.get()).type(), (Object)COMPARE_O2, (Object)((ExprEval)this.initialCombineValue.get()).type()))));
        this.combineBindings = ThreadLocal.withInitial(() -> new SettableObjectBinding(2).withInspector(InputBindings.inspectorFromTypeMap((Map<String, ExpressionType>)ImmutableMap.of((Object)this.accumulatorId, (Object)((ExprEval)this.initialCombineValue.get()).type(), (Object)name, (Object)((ExprEval)this.initialCombineValue.get()).type()))));
        this.finalizeBindings = ThreadLocal.withInitial(() -> new SettableObjectBinding(1).withInspector((Expr.InputBindingInspector)this.finalizeInspector.get()));
        this.finalizeExpression = Parser.lazyParse(this.finalizeExpressionString, macroTable);
        this.maxSizeBytes = maxSizeBytes != null ? maxSizeBytes : DEFAULT_MAX_SIZE_BYTES;
        Preconditions.checkArgument((this.maxSizeBytes.getBytesInInt() >= 10 ? 1 : 0) != 0);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Set<String> getFields() {
        return this.fields;
    }

    @JsonProperty
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAccumulatorIdentifier() {
        return this.accumulatorId;
    }

    @JsonProperty(value="initialValue")
    public String getInitialValueExpressionString() {
        return this.initialValueExpressionString;
    }

    @JsonProperty(value="initialCombineValue")
    public String getInitialCombineValueExpressionString() {
        return this.initialCombineValueExpressionString;
    }

    @JsonProperty(value="isNullUnlessAggregated")
    public boolean getIsNullUnlessAggregated() {
        return this.isNullUnlessAggregated;
    }

    @JsonProperty(value="shouldAggregateNullInputs")
    public boolean getShouldAggregateNullInputs() {
        return this.shouldAggregateNullInputs;
    }

    @JsonProperty(value="shouldCombineAggregateNullInputs")
    public boolean getShouldCombineAggregateNullInputs() {
        return this.shouldCombineAggregateNullInputs;
    }

    @JsonProperty(value="fold")
    public String getFoldExpressionString() {
        return this.foldExpressionString;
    }

    @JsonProperty(value="combine")
    public String getCombineExpressionString() {
        return this.combineExpressionString;
    }

    @JsonProperty(value="compare")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCompareExpressionString() {
        return this.compareExpressionString;
    }

    @JsonProperty(value="finalize")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFinalizeExpressionString() {
        return this.finalizeExpressionString;
    }

    @JsonProperty(value="maxSizeBytes")
    public HumanReadableBytes getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(71).appendStrings(this.fields).appendString(this.initialValueExpressionString).appendString(this.initialCombineValueExpressionString).appendBoolean(this.isNullUnlessAggregated).appendBoolean(this.shouldAggregateNullInputs).appendBoolean(this.shouldCombineAggregateNullInputs).appendCacheable((Cacheable)this.foldExpression.get()).appendCacheable((Cacheable)this.combineExpression.get()).appendCacheable((Cacheable)this.compareExpression.get()).appendCacheable((Cacheable)this.finalizeExpression.get()).appendInt(this.maxSizeBytes.getBytesInInt()).build();
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        FactorizePlan thePlan = new FactorizePlan(metricFactory);
        return new ExpressionLambdaAggregator(thePlan, this.getMaxIntermediateSize());
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        FactorizePlan thePlan = new FactorizePlan(metricFactory);
        return new ExpressionLambdaBufferAggregator(thePlan, this.getMaxIntermediateSize());
    }

    @Override
    public Comparator getComparator() {
        Expr compareExpr = (Expr)this.compareExpression.get();
        if (compareExpr != null) {
            return (o1, o2) -> compareExpr.eval(this.compareBindings.get().withBinding(COMPARE_O1, o1).withBinding(COMPARE_O2, o2)).asInt();
        }
        return ((ExprEval)this.initialCombineValue.get()).type().getStrategy();
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (!this.shouldCombineAggregateNullInputs) {
            if (lhs == null) {
                return rhs;
            }
            if (rhs == null) {
                return lhs;
            }
        }
        return ((Expr)this.combineExpression.get()).eval(this.combineBindings.get().withBinding(this.accumulatorId, lhs).withBinding(this.name, rhs)).valueOrDefault();
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        Expr finalizeExpr = (Expr)this.finalizeExpression.get();
        if (finalizeExpr != null) {
            return finalizeExpr.eval(this.finalizeBindings.get().withBinding(FINALIZE_IDENTIFIER, object)).valueOrDefault();
        }
        return object;
    }

    @Override
    public List<String> requiredFields() {
        if (this.fields == null) {
            return ((Expr)this.combineExpression.get()).analyzeInputs().getRequiredBindingsList();
        }
        return ((Expr)this.foldExpression.get()).analyzeInputs().getRequiredBindingsList();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new ExpressionLambdaAggregatorFactory(this.name, null, this.accumulatorId, this.initialValueExpressionString, this.initialCombineValueExpressionString, this.isNullUnlessAggregated, this.shouldAggregateNullInputs, this.shouldCombineAggregateNullInputs, this.foldExpressionString, this.combineExpressionString, this.compareExpressionString, this.finalizeExpressionString, this.maxSizeBytes, this.macroTable);
    }

    @Override
    public ColumnType getIntermediateType() {
        if (this.fields == null) {
            return ExpressionType.toColumnType(((ExprEval)this.initialCombineValue.get()).type());
        }
        return ExpressionType.toColumnType(((ExprEval)this.initialValue.get()).type());
    }

    @Override
    public ColumnType getResultType() {
        Expr finalizeExpr = (Expr)this.finalizeExpression.get();
        ExprEval initialVal = (ExprEval)this.initialCombineValue.get();
        if (finalizeExpr != null) {
            ExpressionType type = finalizeExpr.getOutputType((Expr.InputBindingInspector)this.finalizeInspector.get());
            if (type == null) {
                type = initialVal.type();
            }
            return ExpressionType.toColumnType(type);
        }
        return ExpressionType.toColumnType(initialVal.type());
    }

    @Override
    public int getMaxIntermediateSize() {
        return this.getIntermediateType().isNumeric() ? 10 : this.maxSizeBytes.getBytesInInt();
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new ExpressionLambdaAggregatorFactory(newName, this.fields, this.accumulatorId, this.initialValueExpressionString, this.initialCombineValueExpressionString, this.isNullUnlessAggregated, this.shouldAggregateNullInputs, this.shouldCombineAggregateNullInputs, this.foldExpressionString, this.combineExpressionString, this.compareExpressionString, this.finalizeExpressionString, this.maxSizeBytes, this.macroTable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionLambdaAggregatorFactory that = (ExpressionLambdaAggregatorFactory)o;
        return this.maxSizeBytes.equals(that.maxSizeBytes) && this.name.equals(that.name) && Objects.equals(this.fields, that.fields) && this.accumulatorId.equals(that.accumulatorId) && this.foldExpressionString.equals(that.foldExpressionString) && this.initialValueExpressionString.equals(that.initialValueExpressionString) && this.initialCombineValueExpressionString.equals(that.initialCombineValueExpressionString) && this.isNullUnlessAggregated == that.isNullUnlessAggregated && this.shouldAggregateNullInputs == that.shouldAggregateNullInputs && this.shouldCombineAggregateNullInputs == that.shouldCombineAggregateNullInputs && this.combineExpressionString.equals(that.combineExpressionString) && Objects.equals(this.compareExpressionString, that.compareExpressionString) && Objects.equals(this.finalizeExpressionString, that.finalizeExpressionString);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fields, this.accumulatorId, this.foldExpressionString, this.initialValueExpressionString, this.initialCombineValueExpressionString, this.isNullUnlessAggregated, this.shouldAggregateNullInputs, this.shouldCombineAggregateNullInputs, this.combineExpressionString, this.compareExpressionString, this.finalizeExpressionString, this.maxSizeBytes);
    }

    public String toString() {
        return "ExpressionLambdaAggregatorFactory{name='" + this.name + "', fields=" + String.valueOf(this.fields) + ", accumulatorId='" + this.accumulatorId + "', foldExpressionString='" + this.foldExpressionString + "', initialValueExpressionString='" + this.initialValueExpressionString + "', initialCombineValueExpressionString='" + this.initialCombineValueExpressionString + "', isNullUnlessAggregated='" + this.isNullUnlessAggregated + "', shouldAggregateNullInputs='" + this.shouldAggregateNullInputs + "', shouldCombineAggregateNullInputs='" + this.shouldCombineAggregateNullInputs + "', combineExpressionString='" + this.combineExpressionString + "', compareExpressionString='" + this.compareExpressionString + "', finalizeExpressionString='" + this.finalizeExpressionString + "', maxSizeBytes=" + String.valueOf(this.maxSizeBytes) + "}";
    }

    public class FactorizePlan {
        private final ExpressionPlan plan;
        private final ExprEval<?> seed;
        private final ExpressionLambdaAggregatorInputBindings bindings;
        private final List<String> inputs = new ArrayList<String>();
        private final boolean aggregateNullInputs;

        FactorizePlan(ColumnSelectorFactory metricFactory) {
            if (ExpressionLambdaAggregatorFactory.this.fields != null) {
                this.plan = ExpressionPlanner.plan(this.inspectorWithAccumulator(metricFactory), (Expr)ExpressionLambdaAggregatorFactory.this.foldExpression.get());
                this.seed = (ExprEval)ExpressionLambdaAggregatorFactory.this.initialValue.get();
                this.aggregateNullInputs = ExpressionLambdaAggregatorFactory.this.shouldAggregateNullInputs;
            } else {
                this.plan = ExpressionPlanner.plan(this.inspectorWithAccumulator(metricFactory), (Expr)ExpressionLambdaAggregatorFactory.this.combineExpression.get());
                this.seed = (ExprEval)ExpressionLambdaAggregatorFactory.this.initialCombineValue.get();
                this.aggregateNullInputs = ExpressionLambdaAggregatorFactory.this.shouldCombineAggregateNullInputs;
            }
            this.bindings = new ExpressionLambdaAggregatorInputBindings(ExpressionSelectors.createBindings(metricFactory, this.plan), ExpressionLambdaAggregatorFactory.this.accumulatorId, this.seed);
            for (String input : this.plan.getAnalysis().getRequiredBindingsList()) {
                if (input.equals(ExpressionLambdaAggregatorFactory.this.accumulatorId)) continue;
                this.inputs.add(input);
            }
        }

        public Expr getExpression() {
            if (ExpressionLambdaAggregatorFactory.this.fields == null) {
                return this.plan.getExpression();
            }
            return this.plan.getAppliedFoldExpression(ExpressionLambdaAggregatorFactory.this.accumulatorId);
        }

        public ExprEval<?> getInitialValue() {
            return this.seed;
        }

        public ExpressionLambdaAggregatorInputBindings getBindings() {
            return this.bindings;
        }

        public List<String> getInputs() {
            return this.inputs;
        }

        public boolean shouldAggregateNullInputs() {
            return this.aggregateNullInputs;
        }

        public boolean isNullUnlessAggregated() {
            return ExpressionLambdaAggregatorFactory.this.isNullUnlessAggregated;
        }

        private ColumnInspector inspectorWithAccumulator(final ColumnInspector inspector) {
            return new ColumnInspector(){

                @Override
                @Nullable
                public ColumnCapabilities getColumnCapabilities(String column) {
                    if (ExpressionLambdaAggregatorFactory.this.accumulatorId.equals(column)) {
                        return ColumnCapabilitiesImpl.createDefault().setType(ExpressionType.toColumnType(((ExprEval)ExpressionLambdaAggregatorFactory.this.initialValue.get()).type()));
                    }
                    return inspector.getColumnCapabilities(column);
                }

                @Override
                @Nullable
                public ExpressionType getType(String name) {
                    if (ExpressionLambdaAggregatorFactory.this.accumulatorId.equals(name)) {
                        return ((ExprEval)ExpressionLambdaAggregatorFactory.this.initialValue.get()).type();
                    }
                    return inspector.getType(name);
                }
            };
        }
    }
}

