/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;

public class ArrayQuantileExprMacro
implements ExprMacroTable.ExprMacro {
    public static final String FN_NAME = "array_quantile";
    private static final String RANK_ARG_NAME = "rank";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 2);
        final Expr arg = args.get(0);
        Expr rankArg = args.get(1);
        this.validationHelperCheckArgIsLiteral(rankArg, RANK_ARG_NAME);
        if (!(rankArg.getLiteralValue() instanceof Number)) {
            throw this.validationFailed("%s must be a number", RANK_ARG_NAME);
        }
        final double rank = ((Number)rankArg.getLiteralValue()).doubleValue();
        class ArrayQuantileExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            private ArrayQuantileExpr(List<Expr> args) {
                super(this$0, args);
            }

            @Override
            @Nonnull
            public ExprEval<?> eval(Expr.ObjectBinding bindings) {
                DoubleList doubles = ArrayQuantileExprMacro.toDoubleArray(arg.eval(bindings));
                if (doubles == null) {
                    return ExprEval.ofDouble(null);
                }
                doubles.sort(null);
                return ExprEval.ofDouble(ArrayQuantileExprMacro.quantileFromSortedArray(doubles, rank));
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.DOUBLE;
            }
        }
        return new ArrayQuantileExpr(args);
    }

    @Nullable
    static DoubleList toDoubleArray(ExprEval<?> eval) {
        if (!eval.type().isArray() || !eval.type().getElementType().isNumeric()) {
            return null;
        }
        Object[] arr = eval.asArray();
        if (arr == null) {
            return null;
        }
        DoubleArrayList doubles = new DoubleArrayList(arr.length);
        for (Object o : arr) {
            if (o == null) continue;
            doubles.add(((Number)o).doubleValue());
        }
        return doubles;
    }

    static double quantileFromSortedArray(DoubleList sortedDoubles, double rank) {
        if (sortedDoubles.size() == 0 || rank < 0.0 || rank > 1.0) {
            return Double.NaN;
        }
        double index = rank * (double)(sortedDoubles.size() - 1);
        if (index <= 0.0) {
            return sortedDoubles.getDouble(0);
        }
        if (index >= (double)(sortedDoubles.size() - 1)) {
            return sortedDoubles.getDouble(sortedDoubles.size() - 1);
        }
        if (index == (double)((int)index)) {
            return sortedDoubles.getDouble((int)index);
        }
        double step = index - (double)((int)index);
        double a = sortedDoubles.getDouble((int)index);
        double b = sortedDoubles.getDouble((int)index + 1);
        return a + step * (b - a);
    }
}

