/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.inject.Inject;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.UnivariateObjectFunctionVectorProcessor;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;

public class LookupExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "lookup";
    private final LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider;

    @Inject
    public LookupExprMacro(LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider) {
        this.lookupExtractorFactoryContainerProvider = lookupExtractorFactoryContainerProvider;
    }

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentRange(args, 2, 3);
        final Expr arg = args.get(0);
        Expr lookupExpr = args.get(1);
        Expr replaceMissingValueWith = this.getReplaceMissingValueWith(args);
        this.validationHelperCheckArgIsLiteral(lookupExpr, "second argument");
        if (lookupExpr.getLiteralValue() == null) {
            throw this.validationFailed("second argument must be a registered lookup name", new Object[0]);
        }
        String lookupName = lookupExpr.getLiteralValue().toString();
        final RegisteredLookupExtractionFn extractionFn = new RegisteredLookupExtractionFn(this.lookupExtractorFactoryContainerProvider, lookupName, false, replaceMissingValueWith != null && replaceMissingValueWith.isLiteral() ? Evals.asString(replaceMissingValueWith.getLiteralValue()) : null, null, null);
        class LookupExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            private LookupExpr(List<Expr> args) {
                super(this$0, args);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                return ExprEval.of(extractionFn.apply(arg.eval(bindings).asString()));
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.STRING;
            }

            @Override
            public boolean canVectorize(Expr.InputBindingInspector inspector) {
                return true;
            }

            @Override
            public <T> ExprVectorProcessor<T> asVectorProcessor(final Expr.VectorInputBindingInspector inspector) {
                final Object[] outputs = new Object[inspector.getMaxVectorSize()];
                UnivariateObjectFunctionVectorProcessor<Object[], Object[]> processor = new UnivariateObjectFunctionVectorProcessor<Object[], Object[]>(CastToTypeVectorProcessor.cast(arg.asVectorProcessor(inspector), ExpressionType.STRING), outputs){

                    @Override
                    public ExpressionType getOutputType() {
                        return ExpressionType.STRING;
                    }

                    @Override
                    public int maxVectorSize() {
                        return inspector.getMaxVectorSize();
                    }

                    @Override
                    public void processIndex(Object[] input, Object[] output, boolean[] outputNulls, int i) {
                        String extracted = extractionFn.apply(input[i]);
                        outputs[i] = extracted;
                    }

                    @Override
                    public ExprEvalVector asEval() {
                        return new ExprEvalObjectVector(outputs, ExpressionType.STRING);
                    }
                };
                return processor;
            }

            @Override
            public void decorateCacheKeyBuilder(CacheKeyBuilder builder) {
                builder.appendCacheable(extractionFn);
            }
        }
        return new LookupExpr(args);
    }

    private Expr getReplaceMissingValueWith(List<Expr> args) {
        if (args.size() > 2) {
            Expr missingValExpr = args.get(2);
            this.validationHelperCheckArgIsLiteral(missingValExpr, "third argument");
            return missingValExpr;
        }
        return null;
    }
}

